'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    updateVisibilityAttribute: function() {
        return updateVisibilityAttribute;
    },
    useOverflowContainer: function() {
        return useOverflowContainer;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _priorityoverflow = require("@fluentui/priority-overflow");
const _reactutilities = require("@fluentui/react-utilities");
const _constants = require("./constants");
const noop = ()=>null;
const useOverflowContainer = (update, options)=>{
    'use no memo';
    const { overflowAxis = 'horizontal', overflowDirection = 'end', padding = 10, minimumVisible = 0, onUpdateItemVisibility = noop, hasHiddenItems = false } = options;
    const onUpdateOverflow = (0, _reactutilities.useEventCallback)(update);
    const overflowOptions = _react.useMemo(()=>({
            overflowAxis,
            overflowDirection,
            padding,
            minimumVisible,
            onUpdateItemVisibility,
            onUpdateOverflow,
            hasHiddenItems
        }), [
        minimumVisible,
        onUpdateItemVisibility,
        overflowAxis,
        overflowDirection,
        padding,
        onUpdateOverflow,
        hasHiddenItems
    ]);
    const firstMount = (0, _reactutilities.useFirstMount)();
    // DOM ref to the overflow container element
    const containerRef = _react.useRef(null);
    const [overflowManager, setOverflowManager] = _react.useState(()=>(0, _reactutilities.canUseDOM)() ? (0, _priorityoverflow.createOverflowManager)() : null);
    // On first mount there is no need to create an overflow manager and re-render
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        if (firstMount && containerRef.current) {
            overflowManager === null || overflowManager === void 0 ? void 0 : overflowManager.observe(containerRef.current, overflowOptions);
        }
    }, [
        firstMount,
        overflowManager,
        overflowOptions
    ]);
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        if (!containerRef.current || !(0, _reactutilities.canUseDOM)() || firstMount) {
            return;
        }
        const newOverflowManager = (0, _priorityoverflow.createOverflowManager)();
        newOverflowManager.observe(containerRef.current, overflowOptions);
        setOverflowManager(newOverflowManager);
    // We don't want to re-create the overflow manager when the first mount flag changes from true to false
    // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [
        overflowOptions
    ]);
    /* Clean up overflow manager on unmount */ _react.useEffect(()=>()=>{
            overflowManager === null || overflowManager === void 0 ? void 0 : overflowManager.disconnect();
        }, [
        overflowManager
    ]);
    const registerItem = _react.useCallback((item)=>{
        overflowManager === null || overflowManager === void 0 ? void 0 : overflowManager.addItem(item);
        item.element.setAttribute(_constants.DATA_OVERFLOW_ITEM, '');
        return ()=>{
            item.element.removeAttribute(_constants.DATA_OVERFLOWING);
            item.element.removeAttribute(_constants.DATA_OVERFLOW_ITEM);
            overflowManager === null || overflowManager === void 0 ? void 0 : overflowManager.removeItem(item.id);
        };
    }, [
        overflowManager
    ]);
    const registerDivider = _react.useCallback((divider)=>{
        const el = divider.element;
        overflowManager === null || overflowManager === void 0 ? void 0 : overflowManager.addDivider(divider);
        el.setAttribute(_constants.DATA_OVERFLOW_DIVIDER, '');
        return ()=>{
            divider.groupId && (overflowManager === null || overflowManager === void 0 ? void 0 : overflowManager.removeDivider(divider.groupId));
            el.removeAttribute(_constants.DATA_OVERFLOW_DIVIDER);
        };
    }, [
        overflowManager
    ]);
    const registerOverflowMenu = _react.useCallback((el)=>{
        overflowManager === null || overflowManager === void 0 ? void 0 : overflowManager.addOverflowMenu(el);
        el.setAttribute(_constants.DATA_OVERFLOW_MENU, '');
        return ()=>{
            overflowManager === null || overflowManager === void 0 ? void 0 : overflowManager.removeOverflowMenu();
            el.removeAttribute(_constants.DATA_OVERFLOW_MENU);
        };
    }, [
        overflowManager
    ]);
    const updateOverflow = _react.useCallback(()=>{
        overflowManager === null || overflowManager === void 0 ? void 0 : overflowManager.update();
    }, [
        overflowManager
    ]);
    return {
        registerItem,
        registerDivider,
        registerOverflowMenu,
        updateOverflow,
        containerRef
    };
};
const updateVisibilityAttribute = ({ item, visible })=>{
    if (visible) {
        item.element.removeAttribute(_constants.DATA_OVERFLOWING);
    } else {
        item.element.setAttribute(_constants.DATA_OVERFLOWING, '');
    }
};
