'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "OverflowItem", {
    enumerable: true,
    get: function() {
        return OverflowItem;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _useOverflowItem = require("../../useOverflowItem");
const OverflowItem = /*#__PURE__*/ _react.forwardRef((props, ref)=>{
    const { id, groupId, priority, children } = props;
    const containerRef = (0, _useOverflowItem.useOverflowItem)(id, priority, groupId);
    const child = (0, _reactutilities.getTriggerChild)(children);
    return (0, _reactutilities.applyTriggerPropsToChildren)(children, {
        ref: (0, _reactutilities.useMergedRefs)(containerRef, ref, (0, _reactutilities.getReactElementRef)(child))
    });
});
// type casting here is required to ensure internal type FluentTriggerComponent is not leaked
OverflowItem.isFluentTriggerComponent = true;
