'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Overflow", {
    enumerable: true,
    get: function() {
        return Overflow;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _react1 = require("@griffel/react");
const _reactutilities = require("@fluentui/react-utilities");
const _overflowContext = require("../overflowContext");
const _useOverflowContainer = require("../useOverflowContainer");
const _useOverflowStylesstyles = require("./useOverflowStyles.styles");
const Overflow = /*#__PURE__*/ _react.forwardRef((props, ref)=>{
    const styles = (0, _useOverflowStylesstyles.useOverflowStyles)();
    const { children, minimumVisible, overflowAxis = 'horizontal', overflowDirection, padding, onOverflowChange, hasHiddenItems } = props;
    const [overflowState, setOverflowState] = _react.useState({
        hasOverflow: false,
        itemVisibility: {},
        groupVisibility: {}
    });
    // useOverflowContainer wraps this method in a useEventCallback.
    const update = (data)=>{
        const { visibleItems, invisibleItems, groupVisibility } = data;
        const itemVisibility = {};
        visibleItems.forEach((item)=>{
            itemVisibility[item.id] = true;
        });
        invisibleItems.forEach((x)=>itemVisibility[x.id] = false);
        const newState = {
            hasOverflow: data.invisibleItems.length > 0,
            itemVisibility,
            groupVisibility
        };
        onOverflowChange === null || onOverflowChange === void 0 ? void 0 : onOverflowChange(null, {
            ...newState
        });
        setOverflowState(newState);
    };
    const { containerRef, registerItem, updateOverflow, registerOverflowMenu, registerDivider } = (0, _useOverflowContainer.useOverflowContainer)(update, {
        overflowDirection,
        overflowAxis,
        padding,
        minimumVisible,
        hasHiddenItems,
        onUpdateItemVisibility: _useOverflowContainer.updateVisibilityAttribute
    });
    const child = (0, _reactutilities.getTriggerChild)(children);
    const clonedChild = (0, _reactutilities.applyTriggerPropsToChildren)(children, {
        ref: (0, _reactutilities.useMergedRefs)(containerRef, ref, (0, _reactutilities.getReactElementRef)(child)),
        className: (0, _react1.mergeClasses)('fui-Overflow', styles.overflowMenu, styles.overflowingItems, child === null || child === void 0 ? void 0 : child.props.className)
    });
    return /*#__PURE__*/ _react.createElement(_overflowContext.OverflowContext.Provider, {
        value: {
            itemVisibility: overflowState.itemVisibility,
            groupVisibility: overflowState.groupVisibility,
            hasOverflow: overflowState.hasOverflow,
            registerItem,
            updateOverflow,
            registerOverflowMenu,
            registerDivider
        }
    }, clonedChild);
});
