'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { motionTokens } from '@fluentui/react-motion';
import { navItemTokens, useRootDefaultClassName } from '../sharedNavStyles.styles';
export const splitNavItemClassNames = {
  root: 'fui-SplitNavItem',
  navItem: 'fui-SplitNavItem__navItem',
  actionButton: 'fui-SplitNavItem__actionButton',
  toggleButton: 'fui-SplitNavItem__toggleButton',
  menuButton: 'fui-SplitNavItem__menuButton',
  /**
  * Tooltips don't have a class name prop, so this is just to satisfy the linter.
  */
  actionButtonTooltip: 'fui-SplitNavItem__actionButtonTooltip',
  toggleButtonTooltip: 'fui-SplitNavItem__toggleButtonTooltip',
  menuButtonTooltip: 'fui-SplitNavItem__menuButtonTooltip'
};
// Don't use makeResetStyles here because the sub components call it once and
// This links says that makeResetStyles should only be called once per element
// https://griffel.js.org/react/api/make-reset-styles/#limitations
const {
  actionButton,
  toggleButton,
  menuButton
} = splitNavItemClassNames;
const buttonHoverStyles = {
  [`& .${actionButton}, & .${toggleButton}, & .${menuButton}`]: {
    opacity: 1,
    pointerEvents: 'auto'
  }
};
/**
 * Styles for the root slot
 */
const useSplitNaveItemStyles = /*#__PURE__*/__styles({
  baseRoot: {
    mc9l5x: "f22iagw",
    i8kkvl: 0,
    Belr9w4: 0,
    rmohyg: "fx80lhs",
    Bt984gj: "f1q9h2pe",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f19jm9xf",
    fsow6f: "fgusgyc",
    De3pzq: "f1ctqxl6",
    B3o57yi: "fnsygzv",
    Bkqvd7p: "f1e9ux7i",
    Bmy1vo4: "f1xfaukr",
    Jwef8y: "f11oyicx",
    xwko9w: "f8z0t4e",
    mcc9px: "f9ueil3",
    B02v5zz: "f1g2hb8n",
    i4x37a: "fpq6je",
    ecr2s2: "f9fof1w"
  },
  baseNavItem: {
    mc9l5x: "f22iagw",
    B9bfxx9: "f1cxpek8",
    qb2dma: "f1ub7u0d",
    fsow6f: ["f1o700av", "fes3tcz"],
    qhf8xq: "f10pi13n",
    Brf1p80: "f1s9ku6b",
    i8kkvl: 0,
    Belr9w4: 0,
    rmohyg: "f1u2hskj",
    De3pzq: "f3rmtva"
  },
  baseSecondary: {
    Bf4jedk: "f107v6xj",
    Bnt446c: "f1y335lp",
    B1hrpyx: "f12pses1",
    rjzwhg: "fibmr9j",
    Bt984gj: "f1s2louj"
  },
  baseMedium: {
    rjzwhg: "fjtod8q"
  },
  baseLarge: {
    rjzwhg: "f16gijt3"
  },
  hoverAction: {
    abs64n: "fk73vx1",
    Bkecrkj: "f1aehjj5",
    Bn62ygk: 0,
    Cwk7ip: 0,
    B3o57yi: 0,
    Bmy1vo4: 0,
    Bkqvd7p: 0,
    Bi2q7bf: ["fr12795", "fcl876f"],
    Es3by: "f1gqqdtu"
  }
}, {
  d: [".f22iagw{display:flex;}", [".fx80lhs{gap:unset;}", {
    p: -1
  }], ".f1q9h2pe{align-items:stretch;}", [".f19jm9xf{padding:unset;}", {
    p: -1
  }], ".fgusgyc{text-align:unset;}", ".f1ctqxl6{background-color:var(--colorNeutralBackground4);}", ".fnsygzv{transition-duration:var(--durationFaster);}", ".f1e9ux7i{transition-timing-function:var(--curveLinear);}", ".f1xfaukr{transition-property:background;}", ".f1cxpek8{text-transform:none;}", ".f1ub7u0d{align-self:stretch;}", ".f1o700av{text-align:left;}", ".fes3tcz{text-align:right;}", ".f10pi13n{position:relative;}", ".f1s9ku6b{justify-content:start;}", [".f1u2hskj{gap:var(--spacingVerticalL);}", {
    p: -1
  }], ".f3rmtva{background-color:transparent;}", ".f107v6xj{min-width:28px;}", ".f1y335lp{-webkit-padding-end:12px;padding-inline-end:12px;}", ".f12pses1{-webkit-padding-start:5px;padding-inline-start:5px;}", ".fibmr9j{padding-block-start:5px;}", ".f1s2louj{align-items:start;}", ".fjtod8q{padding-block-start:9px;}", ".f16gijt3{padding-block-start:12px;}", ".fk73vx1{opacity:0;}", ".f1aehjj5{pointer-events:none;}", [".fr12795{transition:opacity 150ms cubic-bezier(0.33,0,0.67,1);}", {
    p: -1
  }], [".fcl876f{transition:opacity 150ms cubic-bezier(0.33, 0, 0.67, 1);}", {
    p: -1
  }], ".f1gqqdtu{will-change:opacity;}"],
  h: [".f11oyicx:hover{background-color:var(--colorNeutralBackground4Hover);}", ".f8z0t4e:hover .fui-SplitNavItem__actionButton,.f8z0t4e:hover .fui-SplitNavItem__toggleButton,.f8z0t4e:hover .fui-SplitNavItem__menuButton{opacity:1;}", ".f9ueil3:hover .fui-SplitNavItem__actionButton,.f9ueil3:hover .fui-SplitNavItem__toggleButton,.f9ueil3:hover .fui-SplitNavItem__menuButton{pointer-events:auto;}"],
  w: [".f1g2hb8n:focus-within .fui-SplitNavItem__actionButton,.f1g2hb8n:focus-within .fui-SplitNavItem__toggleButton,.f1g2hb8n:focus-within .fui-SplitNavItem__menuButton{opacity:1;}", ".fpq6je:focus-within .fui-SplitNavItem__actionButton,.fpq6je:focus-within .fui-SplitNavItem__toggleButton,.fpq6je:focus-within .fui-SplitNavItem__menuButton{pointer-events:auto;}"],
  a: [".f9fof1w:active{background-color:var(--colorNeutralBackground4Pressed);}"]
});
/**
 * Apply styling to the SplitNavItem slots based on the state
 */
export const useSplitNavItemStyles_unstable = state => {
  'use no memo';

  const splitNavItemStyles = useSplitNaveItemStyles();
  const sharedRootClassNames = useRootDefaultClassName();
  state.root.className = mergeClasses(splitNavItemClassNames.root, sharedRootClassNames, splitNavItemStyles.baseRoot, state.root.className);
  if (state.navItem) {
    state.navItem.className = mergeClasses(splitNavItemClassNames.navItem, splitNavItemStyles.baseNavItem, state.navItem.className);
  }
  if (state.actionButton) {
    state.actionButton.className = mergeClasses(splitNavItemClassNames.actionButton, splitNavItemStyles.baseSecondary, splitNavItemStyles.hoverAction, state.density === 'medium' && splitNavItemStyles.baseMedium, state.actionButton.className);
  }
  if (state.toggleButton) {
    state.toggleButton.className = mergeClasses(splitNavItemClassNames.toggleButton, splitNavItemStyles.baseSecondary, splitNavItemStyles.hoverAction, state.density === 'medium' && splitNavItemStyles.baseMedium, state.toggleButton.className);
  }
  if (state.menuButton) {
    state.menuButton.className = mergeClasses(splitNavItemClassNames.menuButton, splitNavItemStyles.baseSecondary, splitNavItemStyles.hoverAction, state.density === 'medium' && splitNavItemStyles.baseMedium, state.menuButton.className);
  }
  return state;
};