'use client';
import * as React from 'react';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
import { useNavSubItemGroup_unstable } from './useNavSubItemGroup';
import { renderNavSubItemGroup_unstable } from './renderNavSubItemGroup';
import { useNavSubItemGroupStyles_unstable } from './useNavSubItemGroupStyles.styles';
/**
 * NavSubItemGroup component - a group of sub-items within a navigation structure.
 */ export const NavSubItemGroup = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useNavSubItemGroup_unstable(props, ref);
    useNavSubItemGroupStyles_unstable(state);
    useCustomStyleHook_unstable('useNavSubItemGroupStyles_unstable')(state);
    return renderNavSubItemGroup_unstable(state);
});
NavSubItemGroup.displayName = 'NavSubItemGroup';
