'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { navItemTokens, useContentStyles, useIndicatorStyles, useRootDefaultClassName, useSmallStyles } from '../sharedNavStyles.styles';
export const navSubItemClassNames = {
  root: 'fui-NavSubItem'
};
/**
 * Styles for the content slot (children)
 */
const useNavSubItemSpecificStyles = /*#__PURE__*/__styles({
  base: {
    B1hrpyx: "fqo71ku"
  },
  smallBase: {
    B1hrpyx: "f17f9sv1"
  },
  selectedIndicator: {
    rjyhj6: "f1f74g36"
  }
}, {
  d: [".fqo71ku{-webkit-padding-start:46px;padding-inline-start:46px;}", ".f17f9sv1{-webkit-padding-start:40px;padding-inline-start:40px;}", ".f1f74g36::after{-webkit-margin-start:-52px;margin-inline-start:-52px;}"]
});
/**
 * Apply styling to the NavSubItem slots based on the state
 */
export const useNavSubItemStyles_unstable = state => {
  'use no memo';

  const rootDefaultClassName = useRootDefaultClassName();
  const smallStyles = useSmallStyles();
  const contentStyles = useContentStyles();
  const indicatorStyles = useIndicatorStyles();
  const navSubItemSpecificStyles = useNavSubItemSpecificStyles();
  const {
    selected,
    density
  } = state;
  const isSmallDensity = density === 'small';
  state.root.className = mergeClasses(navSubItemClassNames.root, rootDefaultClassName, isSmallDensity && smallStyles.root, isSmallDensity && navSubItemSpecificStyles.smallBase, navSubItemSpecificStyles.base, selected && indicatorStyles.base, selected && contentStyles.selected, selected && navSubItemSpecificStyles.selectedIndicator, state.root.className);
  return state;
};