'use client';
import * as React from 'react';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
import { useNavSubItem_unstable } from './useNavSubItem';
import { renderNavSubItem_unstable } from './renderNavSubItem';
import { useNavSubItemStyles_unstable } from './useNavSubItemStyles.styles';
/**
 * NavSubItem component - a sub-item within a navigation structure.
 */ export const NavSubItem = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useNavSubItem_unstable(props, ref);
    useNavSubItemStyles_unstable(state);
    useCustomStyleHook_unstable('useNavSubItemStyles_unstable')(state);
    return renderNavSubItem_unstable(state);
});
NavSubItem.displayName = 'NavSubItem';
