'use client';
import * as React from 'react';
import { getIntrinsicElementProps, slot, useEventCallback, isHTMLElement } from '@fluentui/react-utilities';
import { useARIAButtonProps } from '@fluentui/react-aria';
import { useNavContext_unstable } from '../NavContext';
/**
 * Create the state required to render NavItem.
 *
 * The returned state can be modified with hooks such as useNavItemStyles_unstable,
 * before being passed to renderNavItem_unstable.
 *
 * @param props - props from this instance of NavItem
 * @param ref - reference to root HTMLAnchorElement of NavItem
 */ export const useNavItem_unstable = (props, ref)=>{
    const { onClick, value, icon, as, href } = props;
    const { selectedValue, onRegister, onUnregister, onSelect, density = 'medium' } = useNavContext_unstable();
    const rootElementType = as || (href ? 'a' : 'button');
    const selected = selectedValue === value;
    const innerRef = React.useRef(null);
    const onNavItemClick = useEventCallback((event)=>{
        onClick === null || onClick === void 0 ? void 0 : onClick(event);
        if (!event.defaultPrevented && isHTMLElement(event.target)) {
            onSelect(event, {
                type: 'click',
                event,
                value
            });
        }
    });
    const root = slot.always(getIntrinsicElementProps(rootElementType, useARIAButtonProps(rootElementType, {
        'aria-current': selected ? 'page' : 'false',
        ...props
    })), {
        elementType: rootElementType,
        defaultProps: {
            ref: ref,
            type: rootElementType
        }
    });
    root.onClick = onNavItemClick;
    React.useEffect(()=>{
        onRegister({
            value,
            ref: innerRef
        });
        return ()=>{
            onUnregister({
                value,
                ref: innerRef
            });
        };
    }, [
        onRegister,
        onUnregister,
        innerRef,
        value
    ]);
    return {
        components: {
            root: rootElementType,
            icon: 'span'
        },
        root,
        icon: slot.optional(icon, {
            elementType: 'span'
        }),
        selected,
        value,
        density
    };
};
