'use client';
import { makeStyles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { useDrawerBodyStyles_unstable } from '@fluentui/react-drawer';
export const navDrawerBodyClassNames = {
    root: 'fui-NavDrawerBody'
};
/**
 * Styles for the root slot
 */ const useStyles = makeStyles({
    root: {
        padding: `0 ${tokens.spacingHorizontalXS} 0 ${tokens.spacingHorizontalMNudge}`,
        alignItems: 'unset',
        display: 'flex',
        flexDirection: 'column',
        rowGap: tokens.spacingVerticalXXS
    }
});
/**
 * Apply styling to the NavDrawerBody slots based on the state
 */ export const useNavDrawerBodyStyles_unstable = (state)=>{
    'use no memo';
    useDrawerBodyStyles_unstable(state);
    const styles = useStyles();
    state.root.className = mergeClasses(navDrawerBodyClassNames.root, styles.root, state.root.className);
    return state;
};
