'use client';
import * as React from 'react';
import { Drawer } from '@fluentui/react-drawer';
import { slot } from '@fluentui/react-utilities';
import { useNav_unstable } from '../Nav/useNav';
/**
 * Create the state required to render NavDrawer.
 *
 * The returned state can be modified with hooks such as useNavDrawerStyles_unstable,
 * before being passed to renderNavDrawer_unstable.
 *
 * @param props - props from this instance of NavDrawer
 * @param ref - reference to root HTMLDivElement of NavDrawer
 */ export const useNavDrawer_unstable = (props, ref)=>{
    const { size = undefined, tabbable = false } = props;
    const navState = useNav_unstable(props, ref);
    return {
        ...navState,
        size,
        tabbable,
        components: {
            // TODO: remove once React v18 slot API is modified
            // this is a problem with the lack of support for union types on React v18
            // ComponentState is using React.ComponentType which will try to infer propType
            // propTypes WeakValidator signature will break distributive unions making this type invalid
            root: Drawer
        },
        root: slot.always({
            ref,
            role: 'navigation',
            ...props
        }, {
            // TODO: remove once React v18 slot API is modified
            // this is a problem with the lack of support for union types on React v18
            // ComponentState is using React.ComponentType which will try to infer propType
            // propTypes WeakValidator signature will break distributive unions making this type invalid
            elementType: Drawer
        })
    };
};
