'use client';
import { makeStyles, mergeClasses } from '@griffel/react';
import { useDividerStyles_unstable } from '@fluentui/react-divider';
export const navDividerClassNames = {
    root: 'fui-NavDivider',
    wrapper: 'fui-NavDivider__wrapper'
};
const useStyles = makeStyles({
    root: {
        flexGrow: 0,
        marginTop: '4px',
        marginBottom: '4px'
    }
});
/**
 * Apply styling to the NavDivider slots based on the state
 */ export const useNavDividerStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = mergeClasses(navDividerClassNames.root, styles.root, state.root.className);
    state.wrapper.className = mergeClasses(navDividerClassNames.wrapper, state.wrapper.className);
    useDividerStyles_unstable(state);
    return state;
};
