'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { typographyStyles } from '@fluentui/react-theme';
import { useContentStyles, useIconStyles, useIndicatorStyles, useRootDefaultClassName, useSmallStyles } from '../sharedNavStyles.styles';
export const navCategoryItemClassNames = {
  root: 'fui-NavCategoryItem',
  icon: 'fui-NavCategoryItem__icon',
  expandIcon: 'fui-NavCategoryItem__expandIcon',
  expandIconMotion: 'fui-NavCategoryItem__expandIconMotion'
};
const useExpandIconStyles = /*#__PURE__*/__styles({
  base: {
    Jyy4pa: "f1lfeew",
    Bqenvij: "fjamq6b"
  },
  open: {
    Bz10aip: ["f93bgaf", "fcxki7x"]
  },
  selected: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fkhj508",
    Bhrd7zp: "fl43uef",
    Bg96gwp: "f1i3iumi"
  }
}, {
  d: [".f1lfeew{-webkit-margin-start:auto;margin-inline-start:auto;}", ".fjamq6b{height:20px;}", ".f93bgaf{transform:rotate(90deg);}", ".fcxki7x{transform:rotate(-90deg);}", ".fk6fouc{font-family:var(--fontFamilyBase);}", ".fkhj508{font-size:var(--fontSizeBase300);}", ".fl43uef{font-weight:var(--fontWeightSemibold);}", ".f1i3iumi{line-height:var(--lineHeightBase300);}"]
});
/**
 * Styles for the root slot
 */
export const useRootStyles = /*#__PURE__*/__styles({
  base: {
    a9b677: "fly5x3f"
  }
}, {
  d: [".fly5x3f{width:100%;}"]
});
/**
 * Apply styling to the NavCategoryItem slots based on the state
 */
export const useNavCategoryItemStyles_unstable = state => {
  'use no memo';

  const rootStyles = useRootStyles();
  const smallStyles = useSmallStyles();
  const defaultRootClassName = useRootDefaultClassName();
  const contentStyles = useContentStyles();
  const indicatorStyles = useIndicatorStyles();
  const iconStyles = useIconStyles();
  const expandIconStyles = useExpandIconStyles();
  const {
    selected,
    open,
    density
  } = state;
  state.root.className = mergeClasses(navCategoryItemClassNames.root, defaultRootClassName, rootStyles.base, density === 'small' && smallStyles.root, selected && open === false && indicatorStyles.base, selected && open === false && contentStyles.selected, state.root.className);
  state.expandIcon.className = mergeClasses(navCategoryItemClassNames.expandIcon, expandIconStyles.base, state.open && expandIconStyles.open, state.expandIcon.className);
  if (state.icon) {
    state.icon.className = mergeClasses(navCategoryItemClassNames.icon, iconStyles.base, selected && iconStyles.selected, state.icon.className);
  }
  return state;
};