'use client';
import * as React from 'react';
import { useNavContext_unstable } from '../NavContext';
/**
 * Create the state required to render NavCategory.
 *
 * The returned state can be modified with hooks such as useNavCategoryStyles_unstable,
 * before being passed to renderNavCategory_unstable.
 *
 * @param props - props from this instance of NavCategory
 * @param ref - reference to root HTMLDivElement of NavCategory
 */ export const useNavCategory_unstable = (props, ref)=>{
    const { value, children } = props;
    const { openCategories } = useNavContext_unstable();
    const open = openCategories === null || openCategories === void 0 ? void 0 : openCategories.includes(value);
    return {
        open,
        value,
        children: children !== null && children !== void 0 ? children : null
    };
};
