'use client';
import * as React from 'react';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
import { useNav_unstable } from './useNav';
import { renderNav_unstable } from './renderNav';
import { useNavStyles_unstable } from './useNavStyles.styles';
import { useNavContextValues_unstable } from '../useNavContextValues';
/**
 * Nav - A component that provides up to two levels of nesting for navigation.
 */ export const Nav = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useNav_unstable(props, ref);
    const contextValues = useNavContextValues_unstable(state);
    useNavStyles_unstable(state);
    useCustomStyleHook_unstable('useHamburgerStyles_unstable')(state);
    return renderNav_unstable(state, contextValues);
});
Nav.displayName = 'Nav';
