'use client';

import { __styles, mergeClasses, shorthands } from '@griffel/react';
import { useButtonStyles_unstable } from '@fluentui/react-button';
import { navItemTokens } from '../sharedNavStyles.styles';
export const hamburgerClassNames = {
  root: 'fui-Hamburger',
  icon: 'fui-Hamburger__icon'
};
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__styles({
  root: {
    w71qe1: "f1iuv45f",
    De3pzq: "f1ctqxl6",
    icvyot: "f1ern45e",
    vrafjx: ["f1n71otn", "f1deefiw"],
    oivjwe: "f1h8hb77",
    wvpqe5: ["f1deefiw", "f1n71otn"],
    Jwef8y: "f11oyicx",
    ecr2s2: "f9fof1w"
  }
}, {
  d: [".f1iuv45f{text-decoration-line:none;}", ".f1ctqxl6{background-color:var(--colorNeutralBackground4);}", ".f1ern45e{border-top-style:none;}", ".f1n71otn{border-right-style:none;}", ".f1deefiw{border-left-style:none;}", ".f1h8hb77{border-bottom-style:none;}"],
  h: [".f11oyicx:hover{background-color:var(--colorNeutralBackground4Hover);}"],
  a: [".f9fof1w:active{background-color:var(--colorNeutralBackground4Pressed);}"]
});
/**
 * Apply styling to the Hamburger slots based on the state
 */
export const useHamburgerStyles_unstable = state => {
  'use no memo';

  useButtonStyles_unstable(state);
  const styles = useStyles();
  state.root.className = mergeClasses(hamburgerClassNames.root, styles.root, state.root.className);
  if (state.icon) {
    state.icon.className = mergeClasses(hamburgerClassNames.icon, state.icon.className);
  }
  return state;
};