'use client';
import * as React from 'react';
import { renderButton_unstable } from '@fluentui/react-button';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
import { useHamburger_unstable } from './useHamburger';
import { useHamburgerStyles_unstable } from './useHamburgerStyles.styles';
/**
 * Hamburger component - a button that toggles a menu or navigation drawer.
 */ export const Hamburger = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useHamburger_unstable(props, ref);
    useHamburgerStyles_unstable(state);
    useCustomStyleHook_unstable('useHamburgerStyles_unstable')(state);
    return renderButton_unstable(state);
});
Hamburger.displayName = 'Hamburger';
