'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { useAppItemStyles } from '../AppItem/useAppItemStyles.styles';
import { useIconStyles, useRootDefaultClassName } from '../sharedNavStyles.styles';
export const appItemStaticClassNames = {
  root: 'fui-AppItemStatic',
  icon: 'fui-AppItemStatic__icon'
};
const useAppItemStaticStyles = /*#__PURE__*/__styles({
  root: {
    Bceei9c: "f158kwzp",
    Jwef8y: "fmaajru",
    ecr2s2: "f11z5bqc"
  }
}, {
  d: [".f158kwzp{cursor:default;}"],
  h: [".fmaajru:hover{background-color:unset;}"],
  a: [".f11z5bqc:active{background-color:unset;}"]
});
/**
 * Apply styling to the AppItemStatic slots based on the state
 */
export const useAppItemStaticStyles_unstable = state => {
  'use no memo';

  const rootDefaultClassName = useRootDefaultClassName();
  const iconStyles = useIconStyles();
  const appItemSpecificStyles = useAppItemStyles();
  const appItemStaticStyles = useAppItemStaticStyles();
  const {
    density,
    icon
  } = state;
  state.root.className = mergeClasses(rootDefaultClassName, appItemStaticClassNames.root, appItemSpecificStyles.root, appItemStaticStyles.root, density === 'small' && appItemSpecificStyles.small, !icon && appItemSpecificStyles.absentIconRootAdjustment, state.root.className);
  if (state.icon) {
    state.icon.className = mergeClasses(appItemStaticClassNames.icon, iconStyles.base, state.icon.className);
  }
  return state;
};