'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { tokens, typographyStyles } from '@fluentui/react-theme';
import { useIconStyles, useRootDefaultClassName } from '../sharedNavStyles.styles';
export const appItemClassNames = {
  root: 'fui-AppItem',
  icon: 'fui-AppItem__icon'
};
/**
 * Styles for the root slot
 */
export const useAppItemStyles = /*#__PURE__*/__styles({
  root: {
    Bokbzmb: "f1x6gvzo",
    Jyy4pa: "f1djyvue",
    B1u1w3b: "feysv1g",
    a9b677: "f1jd6clc",
    Bt984gj: "f122n59",
    i8kkvl: 0,
    Belr9w4: 0,
    rmohyg: "f1ga9sj3",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: ["f1fdqhks", "fnlwq4f"],
    Bahqtrf: "fk6fouc",
    Be2twd7: "fod5ikn",
    Bhrd7zp: "fl43uef",
    Bg96gwp: "faaz57k"
  },
  small: {
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: ["f1m1l4b8", "f1yxbtnt"],
    i8kkvl: 0,
    Belr9w4: 0,
    rmohyg: "f1let0xu"
  },
  absentIconRootAdjustment: {
    B1hrpyx: "ft8721j"
  }
}, {
  d: [[".feysv1g{margin-inline:4px;}", {
    p: -1
  }], ".f1jd6clc{width:revert;}", ".f122n59{align-items:center;}", [".f1ga9sj3{gap:10px;}", {
    p: -1
  }], ".f1djyvue{-webkit-margin-start:-6px;margin-inline-start:-6px;}", ".f1x6gvzo{-webkit-margin-end:0px;margin-inline-end:0px;}", [".f1fdqhks{padding:var(--spacingVerticalS) var(--spacingHorizontalS) var(--spacingVerticalS) var(--spacingHorizontalMNudge);}", {
    p: -1
  }], [".fnlwq4f{padding:var(--spacingVerticalS) var(--spacingHorizontalMNudge) var(--spacingVerticalS) var(--spacingHorizontalS);}", {
    p: -1
  }], ".fk6fouc{font-family:var(--fontFamilyBase);}", ".fod5ikn{font-size:var(--fontSizeBase400);}", ".fl43uef{font-weight:var(--fontWeightSemibold);}", ".faaz57k{line-height:var(--lineHeightBase400);}", [".f1m1l4b8{padding:var(--spacingVerticalS) var(--spacingHorizontalS) var(--spacingVerticalS) 14px;}", {
    p: -1
  }], [".f1yxbtnt{padding:var(--spacingVerticalS) 14px var(--spacingVerticalS) var(--spacingHorizontalS);}", {
    p: -1
  }], [".f1let0xu{gap:14px;}", {
    p: -1
  }], ".ft8721j{-webkit-padding-start:16px;padding-inline-start:16px;}"]
});
/**
 * Apply styling to the AppItem slots based on the state
 */
export const useAppItemStyles_unstable = state => {
  'use no memo';

  const rootDefaultClassName = useRootDefaultClassName();
  const iconStyles = useIconStyles();
  const appItemSpecificStyles = useAppItemStyles();
  const {
    density,
    icon
  } = state;
  state.root.className = mergeClasses(rootDefaultClassName, appItemClassNames.root, appItemSpecificStyles.root, density === 'small' && appItemSpecificStyles.small, !icon && appItemSpecificStyles.absentIconRootAdjustment, state.root.className);
  if (state.icon) {
    state.icon.className = mergeClasses(appItemClassNames.icon, iconStyles.base, state.icon.className);
  }
  return state;
};