"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    navItemTokens: function() {
        return navItemTokens;
    },
    useContentStyles: function() {
        return useContentStyles;
    },
    useIconStyles: function() {
        return useIconStyles;
    },
    useIndicatorStyles: function() {
        return useIndicatorStyles;
    },
    useRootDefaultClassName: function() {
        return useRootDefaultClassName;
    },
    useSmallStyles: function() {
        return useSmallStyles;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const navItemTokens = {
    defaultDrawerWidth: 260,
    indicatorOffset: 16,
    indicatorWidth: 4,
    indicatorHeight: 20,
    backgroundColor: _reacttheme.tokens.colorNeutralBackground4,
    backgroundColorHover: _reacttheme.tokens.colorNeutralBackground4Hover,
    backgroundColorPressed: _reacttheme.tokens.colorNeutralBackground4Pressed,
    animationTokens: {
        animationDuration: _reacttheme.tokens.durationFaster,
        animationFillMode: 'both',
        animationTimingFunction: _reacttheme.tokens.curveLinear
    },
    transitionTokens: {
        transitionDuration: _reacttheme.tokens.durationFaster,
        transitionTimingFunction: _reacttheme.tokens.curveLinear,
        transitionProperty: 'background'
    }
};
const useRootDefaultClassName = /*#__PURE__*/ (0, _react.__resetStyles)("rdi7s9k", "r94071", [
    ".rdi7s9k{display:flex;text-transform:none;position:relative;justify-content:start;align-items:flex-start;text-align:left;gap:var(--spacingVerticalL);padding:var(--spacingVerticalMNudge) var(--spacingHorizontalS) var(--spacingVerticalMNudge) var(--spacingHorizontalMNudge);background-color:var(--colorNeutralBackground4);border-radius:var(--borderRadiusMedium);color:var(--colorNeutralForeground2);text-decoration-line:none;border:none;box-sizing:border-box;cursor:pointer;transition-duration:var(--durationFaster);transition-timing-function:var(--curveLinear);transition-property:background;width:100%;font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase300);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase300);}",
    ".rdi7s9k:hover{background-color:var(--colorNeutralBackground4Hover);}",
    ".rdi7s9k:focus-visible{outline:var(--strokeWidthThick) solid var(--colorStrokeFocus2);outline-offset:calc(var(--strokeWidthThick) * -1);}",
    ".r94071{display:flex;text-transform:none;position:relative;justify-content:start;align-items:flex-start;text-align:right;gap:var(--spacingVerticalL);padding:var(--spacingVerticalMNudge) var(--spacingHorizontalMNudge) var(--spacingVerticalMNudge) var(--spacingHorizontalS);background-color:var(--colorNeutralBackground4);border-radius:var(--borderRadiusMedium);color:var(--colorNeutralForeground2);text-decoration-line:none;border:none;box-sizing:border-box;cursor:pointer;transition-duration:var(--durationFaster);transition-timing-function:var(--curveLinear);transition-property:background;width:100%;font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase300);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase300);}",
    ".r94071:hover{background-color:var(--colorNeutralBackground4Hover);}",
    ".r94071:focus-visible{outline:var(--strokeWidthThick) solid var(--colorStrokeFocus2);outline-offset:calc(var(--strokeWidthThick) * -1);}"
]);
const useSmallStyles = /*#__PURE__*/ (0, _react.__styles)({
    root: {
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: [
            "f1434i56",
            "f1jkyjtc"
        ]
    }
}, {
    d: [
        [
            ".f1434i56{padding:var(--spacingVerticalXS) var(--spacingHorizontalS) var(--spacingVerticalXS) var(--spacingHorizontalMNudge);}",
            {
                p: -1
            }
        ],
        [
            ".f1jkyjtc{padding:var(--spacingVerticalXS) var(--spacingHorizontalMNudge) var(--spacingVerticalXS) var(--spacingHorizontalS);}",
            {
                p: -1
            }
        ]
    ]
});
const useContentStyles = /*#__PURE__*/ (0, _react.__styles)({
    selected: {
        Bahqtrf: "fk6fouc",
        Be2twd7: "fkhj508",
        Bhrd7zp: "fl43uef",
        Bg96gwp: "f1i3iumi"
    }
}, {
    d: [
        ".fk6fouc{font-family:var(--fontFamilyBase);}",
        ".fkhj508{font-size:var(--fontSizeBase300);}",
        ".fl43uef{font-weight:var(--fontWeightSemibold);}",
        ".f1i3iumi{line-height:var(--lineHeightBase300);}"
    ]
});
const useIndicatorStyles = /*#__PURE__*/ (0, _react.__styles)({
    base: {
        E3zdtr: "f1mdlcz9",
        xr36ep: "fpil94b",
        B67388b: "f90z1up",
        Bitv4sc: "f2ic3ny",
        Br128sd: "f1xz7mvd",
        rjyhj6: "f3i5gj0",
        Bjyk6c5: "fi4v1pz",
        Dlnsje: "f1tvrmnx",
        a2br6o: "f1p1ggug",
        d9w3h3: 0,
        B3778ie: 0,
        B4j8arr: 0,
        Bl18szs: 0,
        Blrzh8d: "f3b9emi",
        Bsft5z2: "f13zj6fq",
        faxfa8: 0,
        bj685l: 0,
        Bovfycw: 0,
        B8cfl5i: "fl9mdp8",
        Bg7zzdw: "f6174p6"
    }
}, {
    d: [
        ".f1mdlcz9::after{position:absolute;}",
        ".fpil94b::after{animation-duration:var(--durationFaster);}",
        ".f90z1up::after{animation-fill-mode:both;}",
        ".f2ic3ny::after{animation-timing-function:var(--curveLinear);}",
        ".f1xz7mvd::after{animation-name:f1ayorr4;}",
        ".f3i5gj0::after{-webkit-margin-start:-16px;margin-inline-start:-16px;}",
        ".fi4v1pz::after{background-color:var(--colorCompoundBrandForeground1);}",
        ".f1tvrmnx::after{height:20px;}",
        ".f1p1ggug::after{width:4px;}",
        [
            ".f3b9emi::after{border-radius:var(--borderRadiusCircular);}",
            {
                p: -1
            }
        ],
        ".f13zj6fq::after{content:\"\";}"
    ],
    k: [
        "@keyframes f1ayorr4{0%{background:transparent;}100%{background:var(--colorCompoundBrandForeground1);}}"
    ],
    m: [
        [
            "@media (forced-colors: active){.fl9mdp8::after{outline:solid 2px var(--colorTransparentStroke);}}",
            {
                p: -1,
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f6174p6::after{outline-offset:-2px;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ]
});
const useIconStyles = /*#__PURE__*/ (0, _react.__styles)({
    base: {
        mc9l5x: "f13qh94s",
        zoa1oz: "fngvled",
        sshi5w: "f16gbxbe",
        Bf4jedk: "f11u7vat",
        Bt984gj: "f1w4ww9t",
        Brf1p80: "f4d9j23",
        B68tc82: 0,
        Bmxbyg5: 0,
        Bpg54ce: "f1a3p1vp",
        B9gejnh: 0,
        yr4pdu: 0,
        Bvkmzld: 0,
        mqdk8l: 0,
        Gbjhqp: "f1uiug86",
        obb2bi: "fwrh02z",
        D0sxk3: "f16u1re",
        Esdz9e: 0,
        Bqil8sh: 0,
        Bbom3er: 0,
        djjtid: 0,
        mz70lj: "f1jsjwoh",
        t6yez3: "f8bsbmo"
    },
    selected: {
        C9vb3z: "f5rs5gh",
        ux3ctl: "f1ioc1t6",
        Ba906uv: "fey0lwf",
        D0sxk3: "fxoiby5",
        hndn0g: "fnh0dvc",
        cw2nnk: "fp7jrvw",
        Bkztwl0: "fdt4y6x",
        H8nmoi: "fvl64og",
        ipgedg: "ffh1t26"
    }
}, {
    d: [
        ".f13qh94s{display:grid;}",
        ".fngvled{grid-template-areas:overlay-area;}",
        ".f16gbxbe{min-height:20px;}",
        ".f11u7vat{min-width:20px;}",
        ".f1w4ww9t{align-items:top;}",
        ".f4d9j23{justify-content:center;}",
        [
            ".f1a3p1vp{overflow:hidden;}",
            {
                p: -1
            }
        ],
        [
            ".f1uiug86 .fui-Icon-filled{grid-area:overlay-area;}",
            {
                p: -1
            }
        ],
        ".fwrh02z .fui-Icon-filled{color:transparent;}",
        ".f16u1re .fui-Icon-filled{display:none;}",
        [
            ".f1jsjwoh .fui-Icon-regular{grid-area:overlay-area;}",
            {
                p: -1
            }
        ],
        ".f8bsbmo .fui-Icon-regular{display:inline;}",
        ".f5rs5gh .fui-Icon-filled{animation-duration:var(--durationFaster);}",
        ".f1ioc1t6 .fui-Icon-filled{animation-fill-mode:both;}",
        ".fey0lwf .fui-Icon-filled{animation-timing-function:var(--curveLinear);}",
        ".fxoiby5 .fui-Icon-filled{display:inline;}",
        ".fnh0dvc .fui-Icon-filled{animation-name:f9t3kp0;}",
        ".fp7jrvw .fui-Icon-regular{animation-duration:var(--durationFaster);}",
        ".fdt4y6x .fui-Icon-regular{animation-fill-mode:both;}",
        ".fvl64og .fui-Icon-regular{animation-timing-function:var(--curveLinear);}",
        ".ffh1t26 .fui-Icon-regular{animation-name:fvunsy5;}"
    ],
    k: [
        "@keyframes f9t3kp0{0%{opacity:0;color:transparent;}100%{opacity:1;color:var(--colorNeutralForeground2BrandSelected);}}",
        "@keyframes fvunsy5{0%{opacity:1;color:var(--colorNeutralForeground2);}100%{opacity:0;color:transparent;}}"
    ]
});
