'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    splitNavItemClassNames: function() {
        return splitNavItemClassNames;
    },
    useSplitNavItemStyles_unstable: function() {
        return useSplitNavItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reactmotion = require("@fluentui/react-motion");
const _sharedNavStylesstyles = require("../sharedNavStyles.styles");
const splitNavItemClassNames = {
    root: 'fui-SplitNavItem',
    navItem: 'fui-SplitNavItem__navItem',
    actionButton: 'fui-SplitNavItem__actionButton',
    toggleButton: 'fui-SplitNavItem__toggleButton',
    menuButton: 'fui-SplitNavItem__menuButton',
    /**
   * Tooltips don't have a class name prop, so this is just to satisfy the linter.
   */ actionButtonTooltip: 'fui-SplitNavItem__actionButtonTooltip',
    toggleButtonTooltip: 'fui-SplitNavItem__toggleButtonTooltip',
    menuButtonTooltip: 'fui-SplitNavItem__menuButtonTooltip'
};
// Don't use makeResetStyles here because the sub components call it once and
// This links says that makeResetStyles should only be called once per element
// https://griffel.js.org/react/api/make-reset-styles/#limitations
const { actionButton, toggleButton, menuButton } = splitNavItemClassNames;
const buttonHoverStyles = {
    [`& .${actionButton}, & .${toggleButton}, & .${menuButton}`]: {
        opacity: 1,
        pointerEvents: 'auto'
    }
};
/**
 * Styles for the root slot
 */ const useSplitNaveItemStyles = (0, _react.makeStyles)({
    baseRoot: {
        display: 'flex',
        gap: 'unset',
        alignItems: 'stretch',
        padding: 'unset',
        textAlign: 'unset',
        backgroundColor: _sharedNavStylesstyles.navItemTokens.backgroundColor,
        ..._sharedNavStylesstyles.navItemTokens.transitionTokens,
        ':hover': {
            backgroundColor: _sharedNavStylesstyles.navItemTokens.backgroundColorHover,
            ...buttonHoverStyles
        },
        ':focus-within': buttonHoverStyles,
        ':active': {
            backgroundColor: _sharedNavStylesstyles.navItemTokens.backgroundColorPressed
        }
    },
    baseNavItem: {
        // styles that we want to disagree with the default on
        display: 'flex',
        textTransform: 'none',
        alignSelf: 'stretch',
        textAlign: 'left',
        position: 'relative',
        justifyContent: 'start',
        gap: _reacttheme.tokens.spacingVerticalL,
        backgroundColor: 'transparent'
    },
    baseSecondary: {
        minWidth: '28px',
        paddingInlineEnd: '12px',
        paddingInlineStart: '5px',
        paddingBlockStart: '5px',
        alignItems: 'start'
    },
    baseMedium: {
        paddingBlockStart: '9px'
    },
    baseLarge: {
        paddingBlockStart: '12px'
    },
    hoverAction: {
        opacity: 0,
        pointerEvents: 'none',
        transition: `opacity ${_reactmotion.motionTokens.durationFast}ms ${_reactmotion.motionTokens.curveEasyEase}`,
        willChange: 'opacity'
    }
});
const useSplitNavItemStyles_unstable = (state)=>{
    'use no memo';
    const splitNavItemStyles = useSplitNaveItemStyles();
    const sharedRootClassNames = (0, _sharedNavStylesstyles.useRootDefaultClassName)();
    state.root.className = (0, _react.mergeClasses)(splitNavItemClassNames.root, sharedRootClassNames, splitNavItemStyles.baseRoot, state.root.className);
    if (state.navItem) {
        state.navItem.className = (0, _react.mergeClasses)(splitNavItemClassNames.navItem, splitNavItemStyles.baseNavItem, state.navItem.className);
    }
    if (state.actionButton) {
        state.actionButton.className = (0, _react.mergeClasses)(splitNavItemClassNames.actionButton, splitNavItemStyles.baseSecondary, splitNavItemStyles.hoverAction, state.density === 'medium' && splitNavItemStyles.baseMedium, state.actionButton.className);
    }
    if (state.toggleButton) {
        state.toggleButton.className = (0, _react.mergeClasses)(splitNavItemClassNames.toggleButton, splitNavItemStyles.baseSecondary, splitNavItemStyles.hoverAction, state.density === 'medium' && splitNavItemStyles.baseMedium, state.toggleButton.className);
    }
    if (state.menuButton) {
        state.menuButton.className = (0, _react.mergeClasses)(splitNavItemClassNames.menuButton, splitNavItemStyles.baseSecondary, splitNavItemStyles.hoverAction, state.density === 'medium' && splitNavItemStyles.baseMedium, state.menuButton.className);
    }
    return state;
};
