'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useSplitNavItem_unstable", {
    enumerable: true,
    get: function() {
        return useSplitNavItem_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacttooltip = require("@fluentui/react-tooltip");
const _NavContext = require("../NavContext");
const _reactbutton = require("@fluentui/react-button");
const _reacticons = require("@fluentui/react-icons");
const _index = require("../NavItem/index");
const _NavSubItem = require("../NavSubItem/NavSubItem");
const _NavCategoryContext = require("../NavCategoryContext");
const useSplitNavItem_unstable = (props, ref)=>{
    const { navItem, actionButton, toggleButton, menuButton, actionButtonTooltip, toggleButtonTooltip, menuButtonTooltip, children } = props;
    const { density = 'medium' } = (0, _NavContext.useNavContext_unstable)();
    const { value: potentialParenValue } = (0, _NavCategoryContext.useNavCategoryContext_unstable)();
    const isSubNav = potentialParenValue.length > 0 ? true : false;
    const navItemShorthand = _reactutilities.slot.always(navItem, {
        defaultProps: {
            children
        },
        elementType: isSubNav ? _NavSubItem.NavSubItem : _index.NavItem
    });
    const actionButtonShorthand = _reactutilities.slot.optional(actionButton, {
        defaultProps: {
            icon: /*#__PURE__*/ _react.createElement(_reacticons.Pin20Regular, null),
            size: 'small',
            appearance: 'transparent'
        },
        elementType: _reactbutton.Button
    });
    const toggleButtonShorthand = _reactutilities.slot.optional(toggleButton, {
        defaultProps: {
            icon: /*#__PURE__*/ _react.createElement(_reacticons.Pin20Regular, null),
            size: 'small',
            appearance: 'transparent'
        },
        elementType: _reactbutton.ToggleButton
    });
    const menuButtonShorthand = _reactutilities.slot.optional(menuButton, {
        defaultProps: {
            icon: /*#__PURE__*/ _react.createElement(_reacticons.MoreHorizontalFilled, null),
            size: 'small',
            appearance: 'transparent'
        },
        elementType: _reactbutton.MenuButton
    });
    const actionButtonTooltipShorthand = _reactutilities.slot.optional(actionButtonTooltip, {
        defaultProps: {
            relationship: 'label'
        },
        elementType: _reacttooltip.Tooltip
    });
    const toggleButtonTooltipShorthand = _reactutilities.slot.optional(toggleButtonTooltip, {
        defaultProps: {
            relationship: 'label'
        },
        elementType: _reacttooltip.Tooltip
    });
    const menuButtonTooltipShorthand = _reactutilities.slot.optional(menuButtonTooltip, {
        defaultProps: {
            relationship: 'label'
        },
        elementType: _reacttooltip.Tooltip
    });
    return {
        components: {
            root: 'div',
            navItem: isSubNav ? _NavSubItem.NavSubItem : _index.NavItem,
            actionButton: _reactbutton.Button,
            toggleButton: _reactbutton.ToggleButton,
            menuButton: _reactbutton.MenuButton,
            actionButtonTooltip: _reacttooltip.Tooltip,
            toggleButtonTooltip: _reacttooltip.Tooltip,
            menuButtonTooltip: _reacttooltip.Tooltip
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref,
            ...props,
            // because we're passing in children to the NavItem,
            // We can be explicit about the children prop here
            children: null
        }), {
            elementType: 'div'
        }),
        navItem: navItemShorthand,
        actionButton: actionButtonShorthand,
        toggleButton: toggleButtonShorthand,
        menuButton: menuButtonShorthand,
        actionButtonTooltip: actionButtonTooltipShorthand,
        toggleButtonTooltip: toggleButtonTooltipShorthand,
        menuButtonTooltip: menuButtonTooltipShorthand,
        density,
        isSubNav
    };
};
