'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useNavSubItemGroup_unstable", {
    enumerable: true,
    get: function() {
        return useNavSubItemGroup_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactmotion = require("@fluentui/react-motion");
const _NavCategoryContext = require("../NavCategoryContext");
const _NavContext = require("../NavContext");
const smallSize = 28; // 28px for small density
const largeSize = 40; // 40px for large density
const NavGroupMotion = (0, _reactmotion.createPresenceComponent)(({ items, density })=>{
    const isSmallDensity = density === 'small';
    const height = items ? isSmallDensity ? items * smallSize : items * largeSize : 0;
    const durationPerItem = isSmallDensity ? 15 : 25; // 15ms per item for small, 25ms for large
    const keyframes = [
        {
            opacity: 0,
            minHeight: 0,
            height: 0
        },
        {
            opacity: 1,
            minHeight: `${height}px`,
            height: `${height}px`
        }
    ];
    const baseDuration = _reactmotion.motionTokens.durationFast + (items || 0) * durationPerItem;
    const maxDuration = _reactmotion.motionTokens.durationUltraSlow;
    const duration = baseDuration > maxDuration ? maxDuration : baseDuration;
    return {
        enter: {
            keyframes,
            duration,
            easing: _reactmotion.motionTokens.curveDecelerateMid
        },
        exit: {
            keyframes: [
                ...keyframes
            ].reverse(),
            duration,
            easing: _reactmotion.motionTokens.curveAccelerateMin
        }
    };
});
const useNavSubItemGroup_unstable = (props, ref)=>{
    const { open } = (0, _NavCategoryContext.useNavCategoryContext_unstable)();
    const { density } = (0, _NavContext.useNavContext_unstable)();
    return {
        open,
        components: {
            root: 'div',
            collapseMotion: NavGroupMotion
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ...props,
            ref
        }), {
            elementType: 'div'
        }),
        collapseMotion: (0, _reactmotion.presenceMotionSlot)(props.collapseMotion, {
            elementType: NavGroupMotion,
            defaultProps: {
                visible: open,
                unmountOnExit: true,
                items: _react.Children.count(props.children),
                density
            }
        })
    };
};
