'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    navSubItemClassNames: function() {
        return navSubItemClassNames;
    },
    useNavSubItemStyles_unstable: function() {
        return useNavSubItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _sharedNavStylesstyles = require("../sharedNavStyles.styles");
const navSubItemClassNames = {
    root: 'fui-NavSubItem'
};
/**
 * Styles for the content slot (children)
 */ const useNavSubItemSpecificStyles = (0, _react.makeStyles)({
    base: {
        paddingInlineStart: '46px'
    },
    smallBase: {
        paddingInlineStart: '40px'
    },
    selectedIndicator: {
        '::after': {
            marginInlineStart: `-${_sharedNavStylesstyles.navItemTokens.indicatorOffset + 36}px`
        }
    }
});
const useNavSubItemStyles_unstable = (state)=>{
    'use no memo';
    const rootDefaultClassName = (0, _sharedNavStylesstyles.useRootDefaultClassName)();
    const smallStyles = (0, _sharedNavStylesstyles.useSmallStyles)();
    const contentStyles = (0, _sharedNavStylesstyles.useContentStyles)();
    const indicatorStyles = (0, _sharedNavStylesstyles.useIndicatorStyles)();
    const navSubItemSpecificStyles = useNavSubItemSpecificStyles();
    const { selected, density } = state;
    const isSmallDensity = density === 'small';
    state.root.className = (0, _react.mergeClasses)(navSubItemClassNames.root, rootDefaultClassName, isSmallDensity && smallStyles.root, isSmallDensity && navSubItemSpecificStyles.smallBase, navSubItemSpecificStyles.base, selected && indicatorStyles.base, selected && contentStyles.selected, selected && navSubItemSpecificStyles.selectedIndicator, state.root.className);
    return state;
};
