'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useNavSubItem_unstable", {
    enumerable: true,
    get: function() {
        return useNavSubItem_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactaria = require("@fluentui/react-aria");
const _NavContext = require("../NavContext");
const _NavCategoryContext = require("../NavCategoryContext");
const useNavSubItem_unstable = (props, ref)=>{
    const { onClick, value: subItemValue, as, href } = props;
    const { selectedValue, onRegister, onUnregister, onSelect, density = 'medium' } = (0, _NavContext.useNavContext_unstable)();
    const { value: parentCategoryValue } = (0, _NavCategoryContext.useNavCategoryContext_unstable)();
    const rootElementType = as || (href ? 'a' : 'button');
    const selected = selectedValue === subItemValue;
    const innerRef = _react.useRef(null);
    const onNavSubItemClick = (0, _reactutilities.useEventCallback)((event)=>{
        onClick === null || onClick === void 0 ? void 0 : onClick(event);
        if (!event.defaultPrevented && (0, _reactutilities.isHTMLElement)(event.target)) {
            onSelect(event, {
                type: 'click',
                event,
                value: subItemValue,
                categoryValue: parentCategoryValue
            });
        }
    });
    const root = _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)(rootElementType, (0, _reactaria.useARIAButtonProps)(rootElementType, {
        'aria-current': selected ? 'page' : 'false',
        ...props
    })), {
        elementType: rootElementType,
        defaultProps: {
            ref: ref,
            type: rootElementType
        }
    });
    root.onClick = onNavSubItemClick;
    _react.useEffect(()=>{
        onRegister({
            value: subItemValue,
            ref: innerRef
        });
        return ()=>{
            onUnregister({
                value: subItemValue,
                ref: innerRef
            });
        };
    }, [
        onRegister,
        onUnregister,
        innerRef,
        subItemValue
    ]);
    return {
        components: {
            root: rootElementType
        },
        root,
        selected,
        value: subItemValue,
        density
    };
};
