'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    navItemClassNames: function() {
        return navItemClassNames;
    },
    useNavItemStyles_unstable: function() {
        return useNavItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _sharedNavStylesstyles = require("../sharedNavStyles.styles");
const navItemClassNames = {
    root: 'fui-NavItem',
    icon: 'fui-NavItem__icon'
};
const useNavItemStyles_unstable = (state)=>{
    'use no memo';
    const rootDefaultClassName = (0, _sharedNavStylesstyles.useRootDefaultClassName)();
    const smallStyles = (0, _sharedNavStylesstyles.useSmallStyles)();
    const contentStyles = (0, _sharedNavStylesstyles.useContentStyles)();
    const indicatorStyles = (0, _sharedNavStylesstyles.useIndicatorStyles)();
    const iconStyles = (0, _sharedNavStylesstyles.useIconStyles)();
    const { selected, density } = state;
    state.root.className = (0, _react.mergeClasses)(navItemClassNames.root, rootDefaultClassName, density === 'small' && smallStyles.root, selected && indicatorStyles.base, selected && contentStyles.selected, state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(navItemClassNames.icon, iconStyles.base, selected && iconStyles.selected, state.icon.className);
    }
    return state;
};
