'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useNavItem_unstable", {
    enumerable: true,
    get: function() {
        return useNavItem_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactaria = require("@fluentui/react-aria");
const _NavContext = require("../NavContext");
const useNavItem_unstable = (props, ref)=>{
    const { onClick, value, icon, as, href } = props;
    const { selectedValue, onRegister, onUnregister, onSelect, density = 'medium' } = (0, _NavContext.useNavContext_unstable)();
    const rootElementType = as || (href ? 'a' : 'button');
    const selected = selectedValue === value;
    const innerRef = _react.useRef(null);
    const onNavItemClick = (0, _reactutilities.useEventCallback)((event)=>{
        onClick === null || onClick === void 0 ? void 0 : onClick(event);
        if (!event.defaultPrevented && (0, _reactutilities.isHTMLElement)(event.target)) {
            onSelect(event, {
                type: 'click',
                event,
                value
            });
        }
    });
    const root = _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)(rootElementType, (0, _reactaria.useARIAButtonProps)(rootElementType, {
        'aria-current': selected ? 'page' : 'false',
        ...props
    })), {
        elementType: rootElementType,
        defaultProps: {
            ref: ref,
            type: rootElementType
        }
    });
    root.onClick = onNavItemClick;
    _react.useEffect(()=>{
        onRegister({
            value,
            ref: innerRef
        });
        return ()=>{
            onUnregister({
                value,
                ref: innerRef
            });
        };
    }, [
        onRegister,
        onUnregister,
        innerRef,
        value
    ]);
    return {
        components: {
            root: rootElementType,
            icon: 'span'
        },
        root,
        icon: _reactutilities.slot.optional(icon, {
            elementType: 'span'
        }),
        selected,
        value,
        density
    };
};
