'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    navDrawerClassNames: function() {
        return navDrawerClassNames;
    },
    useNavDrawerStyles_unstable: function() {
        return useNavDrawerStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _sharedNavStylesstyles = require("../sharedNavStyles.styles");
const navDrawerClassNames = {
    root: 'fui-NavDrawer'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        backgroundColor: _sharedNavStylesstyles.navItemTokens.backgroundColor,
        alignItems: 'unset'
    },
    // seperate style so it can be applied conditionally
    // if size is not set, use default width from the token.
    defaultWidth: {
        width: `${_sharedNavStylesstyles.navItemTokens.defaultDrawerWidth}px`
    }
});
const useNavDrawerStyles_unstable = (state)=>{
    'use no memo';
    const { size } = state;
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(navDrawerClassNames.root, styles.root, !size && styles.defaultWidth, state.root.className);
    return state;
};
