'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    navCategoryItemClassNames: function() {
        return navCategoryItemClassNames;
    },
    useNavCategoryItemStyles_unstable: function() {
        return useNavCategoryItemStyles_unstable;
    },
    useRootStyles: function() {
        return useRootStyles;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _sharedNavStylesstyles = require("../sharedNavStyles.styles");
const navCategoryItemClassNames = {
    root: 'fui-NavCategoryItem',
    icon: 'fui-NavCategoryItem__icon',
    expandIcon: 'fui-NavCategoryItem__expandIcon',
    expandIconMotion: 'fui-NavCategoryItem__expandIconMotion'
};
const useExpandIconStyles = (0, _react.makeStyles)({
    base: {
        marginInlineStart: 'auto',
        height: '20px'
    },
    open: {
        transform: 'rotate(90deg)'
    },
    selected: _reacttheme.typographyStyles.body1Strong
});
const useRootStyles = (0, _react.makeStyles)({
    base: {
        width: '100%'
    }
});
const useNavCategoryItemStyles_unstable = (state)=>{
    'use no memo';
    const rootStyles = useRootStyles();
    const smallStyles = (0, _sharedNavStylesstyles.useSmallStyles)();
    const defaultRootClassName = (0, _sharedNavStylesstyles.useRootDefaultClassName)();
    const contentStyles = (0, _sharedNavStylesstyles.useContentStyles)();
    const indicatorStyles = (0, _sharedNavStylesstyles.useIndicatorStyles)();
    const iconStyles = (0, _sharedNavStylesstyles.useIconStyles)();
    const expandIconStyles = useExpandIconStyles();
    const { selected, open, density } = state;
    state.root.className = (0, _react.mergeClasses)(navCategoryItemClassNames.root, defaultRootClassName, rootStyles.base, density === 'small' && smallStyles.root, selected && open === false && indicatorStyles.base, selected && open === false && contentStyles.selected, state.root.className);
    state.expandIcon.className = (0, _react.mergeClasses)(navCategoryItemClassNames.expandIcon, expandIconStyles.base, state.open && expandIconStyles.open, state.expandIcon.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(navCategoryItemClassNames.icon, iconStyles.base, selected && iconStyles.selected, state.icon.className);
    }
    return state;
};
