'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useNavCategoryItem_unstable", {
    enumerable: true,
    get: function() {
        return useNavCategoryItem_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacticons = require("@fluentui/react-icons");
const _reactmotion = require("@fluentui/react-motion");
const _NavCategoryContext = require("../NavCategoryContext");
const _NavContext = require("../NavContext");
const ExpandIconMotion = (0, _reactmotion.createPresenceComponent)(()=>{
    const keyframes = [
        {
            transform: 'rotate(0deg) translate3D(0, 0, 0)'
        },
        {
            transform: 'rotate(180deg) translate3D(0, 0, 0)'
        }
    ];
    const duration = _reactmotion.motionTokens.durationFast;
    const easing = _reactmotion.motionTokens.curveEasyEase;
    return {
        enter: {
            keyframes,
            duration,
            easing
        },
        exit: {
            keyframes: [
                ...keyframes
            ].reverse(),
            duration,
            easing
        }
    };
});
const useNavCategoryItem_unstable = (props, ref)=>{
    const { onClick, expandIcon, icon } = props;
    const { open, value } = (0, _NavCategoryContext.useNavCategoryContext_unstable)();
    const { onRequestNavCategoryItemToggle, selectedCategoryValue, density = 'medium' } = (0, _NavContext.useNavContext_unstable)();
    const onNavCategoryItemClick = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(onClick, (event)=>onRequestNavCategoryItemToggle(event, {
            type: 'click',
            event,
            value: '',
            categoryValue: value
        })));
    // don't fill the icon when it's open
    const selected = selectedCategoryValue === value && !open;
    // there's more than 2 possible values for aria-current, but this is the only one that's used in this component
    const validAriaCurrent = selected && !open ? 'page' : 'false';
    return {
        open,
        value,
        selected,
        components: {
            root: 'button',
            icon: 'span',
            expandIcon: 'span',
            expandIconMotion: ExpandIconMotion
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('button', {
            ref,
            'aria-current': validAriaCurrent,
            'aria-expanded': open,
            ...props,
            onClick: onNavCategoryItemClick
        }), {
            elementType: 'button'
        }),
        expandIcon: _reactutilities.slot.always(expandIcon, {
            defaultProps: {
                children: /*#__PURE__*/ _react.createElement(_reacticons.ChevronDown20Regular, null),
                'aria-hidden': true
            },
            elementType: 'span'
        }),
        expandIconMotion: (0, _reactmotion.presenceMotionSlot)(props.expandIconMotion, {
            elementType: ExpandIconMotion,
            defaultProps: {
                visible: open
            }
        }),
        icon: _reactutilities.slot.optional(icon, {
            elementType: 'span'
        }),
        density
    };
};
