'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    appItemClassNames: function() {
        return appItemClassNames;
    },
    useAppItemStyles: function() {
        return useAppItemStyles;
    },
    useAppItemStyles_unstable: function() {
        return useAppItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _sharedNavStylesstyles = require("../sharedNavStyles.styles");
const appItemClassNames = {
    root: 'fui-AppItem',
    icon: 'fui-AppItem__icon'
};
const useAppItemStyles = (0, _react.makeStyles)({
    root: {
        marginInline: '4px',
        width: 'revert',
        alignItems: 'center',
        gap: '10px',
        marginInlineStart: '-6px',
        marginInlineEnd: '0px',
        padding: `${_reacttheme.tokens.spacingVerticalS} ${_reacttheme.tokens.spacingHorizontalS} ${_reacttheme.tokens.spacingVerticalS} ${_reacttheme.tokens.spacingHorizontalMNudge}`,
        ..._reacttheme.typographyStyles.subtitle2
    },
    small: {
        padding: `${_reacttheme.tokens.spacingVerticalS} ${_reacttheme.tokens.spacingHorizontalS} ${_reacttheme.tokens.spacingVerticalS} 14px`,
        gap: '14px'
    },
    absentIconRootAdjustment: {
        paddingInlineStart: '16px'
    }
});
const useAppItemStyles_unstable = (state)=>{
    'use no memo';
    const rootDefaultClassName = (0, _sharedNavStylesstyles.useRootDefaultClassName)();
    const iconStyles = (0, _sharedNavStylesstyles.useIconStyles)();
    const appItemSpecificStyles = useAppItemStyles();
    const { density, icon } = state;
    state.root.className = (0, _react.mergeClasses)(rootDefaultClassName, appItemClassNames.root, appItemSpecificStyles.root, density === 'small' && appItemSpecificStyles.small, !icon && appItemSpecificStyles.absentIconRootAdjustment, state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(appItemClassNames.icon, iconStyles.base, state.icon.className);
    }
    return state;
};
