import { ARIAButtonSlotProps } from '@fluentui/react-aria';
import { ButtonProps } from '@fluentui/react-button';
import { ButtonSlots } from '@fluentui/react-button';
import { ButtonState } from '@fluentui/react-button';
import { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { DividerProps } from '@fluentui/react-divider';
import { DividerSlots } from '@fluentui/react-divider';
import type { DividerState } from '@fluentui/react-divider';
import type { DrawerBodyProps } from '@fluentui/react-drawer';
import type { DrawerBodySlots } from '@fluentui/react-drawer';
import type { DrawerBodyState } from '@fluentui/react-drawer';
import type { DrawerFooterProps } from '@fluentui/react-drawer';
import type { DrawerFooterSlots } from '@fluentui/react-drawer';
import type { DrawerFooterState } from '@fluentui/react-drawer';
import type { DrawerHeaderProps } from '@fluentui/react-drawer';
import type { DrawerHeaderSlots } from '@fluentui/react-drawer';
import type { DrawerHeaderState } from '@fluentui/react-drawer';
import { DrawerProps } from '@fluentui/react-drawer';
import { DrawerSlots } from '@fluentui/react-drawer';
import { DrawerState } from '@fluentui/react-drawer';
import type { EventData } from '@fluentui/react-utilities';
import { EventHandler } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { InlineDrawerSlots } from '@fluentui/react-drawer';
import type { JSXElement } from '@fluentui/react-utilities';
import { MenuButtonProps } from '@fluentui/react-button';
import { PresenceMotionSlotProps } from '@fluentui/react-motion';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import { SlotClassNames } from '@fluentui/react-utilities';
import { ToggleButtonProps } from '@fluentui/react-button';
import type { TooltipProps } from '@fluentui/react-tooltip';

/**
 * AppItem component - Application item in the navigation menu.
 */
export declare const AppItem: ForwardRefComponent<AppItemProps>;

export declare const appItemClassNames: SlotClassNames<AppItemSlots>;

/**
 * AppItem Props
 */
export declare type AppItemProps = ComponentProps<AppItemSlots> & {
    href?: string;
};

export declare type AppItemSlots = {
    /**
     * The root element of the AppItem.
     */
    root: NonNullable<Slot<ARIAButtonSlotProps<'a'>>>;
    /**
     * Icon that renders before the content.
     */
    icon?: Slot<'span'>;
};

/**
 * State used in rendering AppItem
 */
export declare type AppItemState = ComponentState<AppItemSlots> & {
    /**
     * The density of the NavItem
     *
     * @default 'medium'
     */
    density: NavDensity;
};

/**
 * AppItemStatic component - Static application item in the navigation menu.
 */
export declare const AppItemStatic: ForwardRefComponent<AppItemStaticProps>;

export declare const appItemStaticClassNames: SlotClassNames<AppItemStaticSlots>;

/**
 * AppItemStatic Props
 */
export declare type AppItemStaticProps = ComponentProps<AppItemStaticSlots> & {};

export declare type AppItemStaticSlots = {
    /**
     * The root element of the AppItemStatic.
     */
    root: Slot<'div'>;
    /**
     * Icon that renders before the content.
     */
    icon?: Slot<'span'>;
};

/**
 * State used in rendering AppItemStatic
 */
export declare type AppItemStaticState = ComponentState<AppItemStaticSlots> & {
    /**
     * The density of the Nav
     *
     * @default 'medium'
     */
    density: NavDensity;
};

/**
 * Hamburger component - a button that toggles a menu or navigation drawer.
 */
export declare const Hamburger: ForwardRefComponent<HamburgerProps>;

export declare const hamburgerClassNames: SlotClassNames<ButtonSlots>;

/**
 * Hamburger Props
 */
export declare type HamburgerProps = ButtonProps;

/**
 * State used in rendering Hamburger
 */
export declare type HamburgerState = ButtonState;

/**
 * Nav - A component that provides up to two levels of nesting for navigation.
 */
export declare const Nav: ForwardRefComponent<NavProps>;

/**
 * NavCategory component - a category in the navigation menu that can contain multiple items.
 */
export declare const NavCategory: ForwardRefComponent<NavCategoryProps>;

declare type NavCategoryContextValue = {
    open: boolean;
    value: NavItemValue;
};

export declare type NavCategoryContextValues = {
    categoryValue: NavCategoryContextValue;
};

/**
 * A Nav Category Item provides provides a clickable accordion like header that exposes
 * a list of NavSubItems to take users to a new destination.
 */
export declare const NavCategoryItem: ForwardRefComponent<NavCategoryItemProps>;

export declare const navCategoryItemClassNames: SlotClassNames<NavCategoryItemSlots>;

declare type NavCategoryItemContextValue = {
    open: boolean;
    value: NavItemValue;
};

export declare type NavCategoryItemContextValues = {
    navCategoryItem: NavCategoryItemContextValue;
};

/**
 * navCategoryItem Props
 */
export declare type NavCategoryItemProps = ComponentProps<Partial<NavCategoryItemSlots>>;

export declare const NavCategoryItemProvider: React_2.Provider<NavCategoryItemContextValue>;

export declare type NavCategoryItemSlots = {
    /**
     * The root element
     */
    root: NonNullable<Slot<'button'>>;
    /**
     * Icon that renders before the content.
     * Should be specific to each Category
     */
    icon?: Slot<'span'>;
    /**
     * Expand icon slot rendered after the content to indicate an open and closed state.
     */
    expandIcon: NonNullable<Slot<'span'>>;
    /**
     * Expand icon motion slot.
     */
    expandIconMotion?: Slot<PresenceMotionSlotProps>;
};

/**
 * State used in rendering NavCategoryItem
 */
export declare type NavCategoryItemState = ComponentState<NavCategoryItemSlots> & NavCategoryItemContextValue & {
    /**
     * If this navCategoryItem is selected
     */
    selected: boolean;
    /**
     * The density of the NavItem
     *
     * @default 'medium'
     */
    density: NavDensity;
};

/**
 * NavCategory Props
 */
export declare type NavCategoryProps = {
    /**
     * Required value that identifies this item inside an Nav component.
     */
    value: NavItemValue;
    /**
     * Children of the NavCategory
     */
    children?: React_2.ReactNode | null;
};

export declare const NavCategoryProvider: React_2.Provider<NavCategoryContextValue>;

/**
 * State used in rendering NavCategory
 */
export declare type NavCategoryState = NavCategoryContextValue & Required<NavCategoryProps>;

export declare const navClassNames: SlotClassNames<NavSlots>;

export declare type NavContextValue = Pick<NavProps, 'onNavItemSelect' | 'selectedValue' | 'selectedCategoryValue' | 'density'> & {
    /** A callback to allow a navItem to register itself with the navItem list. */
    onRegister: RegisterNavItemEventHandler;
    /** A callback to allow a navItem to unregister itself with the navItem list. */
    onUnregister: RegisterNavItemEventHandler;
    /**
     * A callback to allow a navItem to select itself when pressed.
     */
    onSelect: EventHandler<OnNavItemSelectData>;
    /**
     * Gets the registered navItem data along with current and previous selected values.
     */
    getRegisteredNavItems: () => {
        selectedValue?: NavItemValue;
        selectedCategoryValue?: NavItemValue;
        previousSelectedValue?: NavItemValue;
        registeredNavItems: Record<string, NavItemRegisterData>;
    };
    /**
     * Callback used by NavCategoryItem to request a change on it's own opened state
     * Should be used to toggle NavCategoryItem's open state
     */
    onRequestNavCategoryItemToggle: EventHandler<OnNavItemSelectData>;
    /**
     * The list of opened panels by index
     */
    openCategories: NavItemValue[];
    /**
     * Indicates if Nav supports multiple open Categories at the same time.
     * @default true, indicating that multiple categories can be open at the same time.
     */
    multiple: boolean;
    /**
     * Setting this to true enables tab AND arrow navigation.
     * @default false
     */
    tabbable: boolean;
};

/**
 * Context values used in rendering navItemList.
 */
export declare type NavContextValues = {
    /**
     * The context of the navItem list available to each navItem.
     */
    nav: NavContextValue;
};

/***
 * Indicates the vertical density of the Nav content.
 * This does not affect horizontal spacing.
 */
export declare type NavDensity = 'small' | 'medium';

/**
 * NavDivider component - a divider used within navigation components to separate items.
 */
export declare const NavDivider: ForwardRefComponent<NavDividerProps>;

export declare const navDividerClassNames: SlotClassNames<DividerSlots>;

/**
 * NavDivider Props
 */
export declare type NavDividerProps = DividerProps;

/**
 * State used in rendering NavDivider
 */
export declare type NavDividerState = DividerState;

/**
 * NavDrawer component - a component that provides a drawer for navigation items.
 */
export declare const NavDrawer: ForwardRefComponent<NavDrawerProps>;

/**
 * NavDrawerBody component
 */
export declare const NavDrawerBody: ForwardRefComponent<NavDrawerBodyProps>;

export declare const navDrawerBodyClassNames: SlotClassNames<NavDrawerBodySlots>;

/**
 * NavDrawerBody Props
 */
export declare type NavDrawerBodyProps = DrawerBodyProps;

export declare type NavDrawerBodySlots = DrawerBodySlots;

/**
 * State used in rendering NavDrawerBody
 */
export declare type NavDrawerBodyState = DrawerBodyState;

export declare const navDrawerClassNames: SlotClassNames<Omit<InlineDrawerSlots, 'surfaceMotion'>>;

/**
 * NavDrawerFooter component
 */
export declare const NavDrawerFooter: ForwardRefComponent<NavDrawerFooterProps>;

export declare const navDrawerFooterClassNames: SlotClassNames<NavDrawerFooterSlots>;

/**
 * NavDrawerFooter Props
 */
export declare type NavDrawerFooterProps = DrawerFooterProps;

export declare type NavDrawerFooterSlots = DrawerFooterSlots;

/**
 * State used in rendering NavDrawerFooter
 */
export declare type NavDrawerFooterState = DrawerFooterState;

/**
 * NavDrawerHeader component
 */
export declare const NavDrawerHeader: ForwardRefComponent<NavDrawerHeaderProps>;

export declare const navDrawerHeaderClassNames: SlotClassNames<NavDrawerHeaderSlots>;

/**
 * NavDrawerHeader Props
 */
export declare type NavDrawerHeaderProps = DrawerHeaderProps;

export declare type NavDrawerHeaderSlots = DrawerHeaderSlots;

/**
 * State used in rendering NavDrawerHeader
 */
export declare type NavDrawerHeaderState = DrawerHeaderState;

/**
 * NavDrawer Props
 */
export declare type NavDrawerProps = ComponentProps<NavDrawerSlots> & DrawerProps & NavProps & {
    /**
     * The component uses arrow navigation by default.
     * Setting this to true enables tab AND arrow navigation.
     * @default false
     */
    tabbable?: boolean;
};

/**
 * NavDrawer slots
 */
export declare type NavDrawerSlots = DrawerSlots;

/**
 * State used in rendering NavDrawer
 */
export declare type NavDrawerState = DrawerState & NavContextValue & {
    /**
     * Analagous to size from DrawerBaseProps.
     * Intended to be left unset in most cases.
     * If left unset, it defaults to 260px.
     */
    size?: 'small' | 'medium' | 'large' | 'full';
};

/**
 * NavItem component - a single item in the navigation menu.
 */
export declare const NavItem: ForwardRefComponent<NavItemProps>;

export declare const navItemClassNames: SlotClassNames<NavItemSlots>;

/**
 * NavItem Props
 */
export declare type NavItemProps = ComponentProps<NavItemSlots> & {
    /**
     * Destination where the nav item points to.
     */
    href?: string;
    /**
     * The value that identifies this navCategoryItem when selected.
     */
    value: NavItemValue;
};

export declare type NavItemRegisterData = {
    /**
     * The value of the navItem.
     */
    value: NavItemValue;
    /**
     * The reference to the navItem HTML element.
     */
    ref: React_2.RefObject<HTMLElement | null>;
};

export declare type NavItemSlots = {
    /**
     * The root element of the NavItem.
     */
    root: NonNullable<Slot<ARIAButtonSlotProps<'a'>>>;
    /**
     * Icon that renders before the content.
     */
    icon?: Slot<'span'>;
};

/**
 * State used in rendering NavItem
 */
export declare type NavItemState = ComponentState<NavItemSlots> & Pick<NavItemProps, 'value'> & {
    /**
     * If this navCategoryItem is selected
     */
    selected: boolean;
    /**
     * The density of the NavItem
     *
     * @default 'medium'
     */
    density: NavDensity;
};

/**
 * Any value that identifies a specific Item.
 */
export declare type NavItemValue = string;

/**
 * Nav Props
 */
export declare type NavProps = ComponentProps<NavSlots> & {
    /**
     * The value of the navItem to be selected by default.
     * Typically useful when the selectedValue is uncontrolled.
     * Mutually exclusive with selectedValue.
     * Empty string indicates no selection.
     */
    defaultSelectedValue?: NavItemValue;
    /**
     * The value of the navCategory to be selected by default.
     * Typically useful when the selectedValue is uncontrolled.
     * Mutually exclusive with selectedValue.
     * Empty string indicates no selection.
     */
    defaultSelectedCategoryValue?: NavItemValue;
    /**
     * Set of categories that are opened by default.
     * Typically useful when the openCategories is uncontrolled.
     */
    defaultOpenCategories?: NavItemValue[];
    /**
     * Controls the open categories.
     * For use in controlled scenarios.
     */
    openCategories?: NavItemValue[];
    /**
     * Raised when a navItem is selected.
     * If the navItem is child of a category, the categoryValue will be provided
     */
    onNavItemSelect?: EventHandler<OnNavItemSelectData>;
    /**
     * The value of the currently selected navItem.
     * Mutually exclusive with defaultSelectedValue.
     * @default undefined
     */
    selectedValue?: NavItemValue;
    /**
     * Indicates a category that has a selected child
     * Will show the category as selected if it is closed.
     * @default undefined
     */
    selectedCategoryValue?: NavItemValue;
    /**
     * Indicates if Nav supports multiple open Categories at the same time.
     * @default true, indicating that multiple categories can be open at the same time.
     */
    multiple?: boolean;
    /**
     * Callback raised when a NavCategoryItem is toggled.
     */
    onNavCategoryItemToggle?: EventHandler<OnNavItemSelectData>;
    /**
     * The vertical density of the Nav and it's children
     * @default 'medium'
     */
    density?: NavDensity;
};

export declare const NavProvider: React_2.Provider<NavContextValue | undefined>;

/**
 * NavSectionHeader component
 */
export declare const NavSectionHeader: ForwardRefComponent<NavSectionHeaderProps>;

export declare const navSectionHeaderClassNames: SlotClassNames<NavSectionHeaderSlots>;

/**
 * NavSectionHeader Props
 */
export declare type NavSectionHeaderProps = ComponentProps<NavSectionHeaderSlots>;

export declare type NavSectionHeaderSlots = {
    root: Slot<'h2', 'h1' | 'h3' | 'h4' | 'h5' | 'h6' | 'div'>;
};

/**
 * State used in rendering NavSectionHeader
 */
export declare type NavSectionHeaderState = ComponentState<NavSectionHeaderSlots>;

export declare type NavSlots = {
    root: NonNullable<Slot<'div'>>;
};

/**
 * State used in rendering Nav
 */
export declare type NavState = ComponentState<NavSlots> & NavContextValue;

/**
 * NavSubItem component - a sub-item within a navigation structure.
 */
export declare const NavSubItem: ForwardRefComponent<NavSubItemProps>;

export declare const navSubItemClassNames: SlotClassNames<NavSubItemSlots>;

/**
 * NavSubItemGroup component - a group of sub-items within a navigation structure.
 */
export declare const NavSubItemGroup: ForwardRefComponent<NavSubItemGroupProps>;

export declare const navSubItemGroupClassNames: SlotClassNames<Omit<NavSubItemGroupSlots, 'collapseMotion'>>;

/**
 * Context value for NavSubItemGroup
 */
declare type NavSubItemGroupCollapseMotionParams = {
    /**
     * The number of items in the NavSubItemGroup
     */
    items?: number;
    /**
     * The density of the NavItem
     */
    density?: NavDensity;
};

/**
 * NavSubItemGroup Props
 */
export declare type NavSubItemGroupProps = ComponentProps<NavSubItemGroupSlots>;

export declare type NavSubItemGroupSlots = {
    /**
     * The root element
     */
    root: NonNullable<Slot<'div'>>;
    /**
     * Collapse motion slot
     */
    collapseMotion?: Slot<PresenceMotionSlotProps<NavSubItemGroupCollapseMotionParams>>;
};

/**
 * State used in rendering NavSubItemGroup
 */
export declare type NavSubItemGroupState = ComponentState<NavSubItemGroupSlots> & {
    /**
     * Internal open state, provided by context.
     */
    open: boolean;
};

/**
 * NavSubItem Props
 */
export declare type NavSubItemProps = ComponentProps<NavSubItemSlots> & {
    href?: string;
    /**
     * The value that identifies this NavSubItem when selected.
     */
    value: NavItemValue;
};

export declare type NavSubItemSlots = {
    root: NonNullable<Slot<ARIAButtonSlotProps<'a'>>>;
};

/**
 * State used in rendering NavSubItem
 */
export declare type NavSubItemState = ComponentState<NavSubItemSlots> & Pick<NavSubItemProps, 'value'> & {
    /**
     * If this NavSubItem is selected
     */
    selected: boolean;
    /**
     * The density of the NavItem
     *
     * @default 'medium'
     */
    density: NavDensity;
};

export declare type OnNavItemSelectData = EventData<'click', React_2.MouseEvent<HTMLButtonElement | HTMLAnchorElement>> & {
    /**
     * The value of the selected navItem.
     * In the case of a category selection, this will be the value of the selected category.
     */
    value: NavItemValue;
    /**
     * The parent value of the selected navSubItem
     * Null if not a child of a category
     */
    categoryValue?: NavItemValue;
};

export declare type RegisterNavItemEventHandler = (data: NavItemRegisterData) => void;

/**
 * Render the final JSX of AppItem
 */
export declare const renderAppItem_unstable: (state: AppItemState) => JSXElement;

/**
 * Render the final JSX of AppItemStatic
 */
export declare const renderAppItemStatic_unstable: (state: AppItemStaticState) => JSXElement;

export declare const renderNav_unstable: (state: NavState, contextValues: NavContextValues) => JSXElement;

/**
 * Render the final JSX of NavCategory
 */
export declare const renderNavCategory_unstable: (state: NavCategoryState, contextValues: NavCategoryContextValues) => JSXElement;

/**
 * Render the final JSX of NavCategoryItem
 */
export declare const renderNavCategoryItem_unstable: (state: NavCategoryItemState, contextValues: NavCategoryItemContextValues) => JSXElement;

export declare const renderNavDrawer_unstable: (state: NavDrawerState, contextValues: NavContextValues) => JSXElement;

/**
 * Render the final JSX of NavItem
 */
export declare const renderNavItem_unstable: (state: NavItemState) => JSXElement;

/**
 * Render the final JSX of NavSectionHeader
 */
export declare const renderNavSectionHeader_unstable: (state: NavSectionHeaderState) => JSXElement;

/**
 * Render the final JSX of NavSubItem
 */
export declare const renderNavSubItem_unstable: (state: NavSubItemState) => JSXElement;

/**
 * Render the final JSX of NavSubItemGroup
 */
export declare const renderNavSubItemGroup_unstable: (state: NavSubItemGroupState) => JSXElement;

/**
 * Render the final JSX of SplitNavItem
 */
export declare const renderSplitNavItem_unstable: (state: SplitNavItemState) => JSXElement;

/**
 * SplitNavItem component - TODO: add more docs
 */
export declare const SplitNavItem: ForwardRefComponent<SplitNavItemProps>;

export declare const splitNavItemClassNames: SlotClassNames<SplitNavItemSlots>;

/**
 * SplitNavItem Props
 */
export declare type SplitNavItemProps = ComponentProps<SplitNavItemSlots>;

export declare type SplitNavItemSlots = {
    /**
     * Root of the component, wrapping the children.
     */
    root: Slot<'div'>;
    /**
     * The NavItem Slot.
     * Will behave as a SubNavItem if it's in an a SubGroup.
     */
    navItem?: NonNullable<Slot<NavItemProps & NavSubItemProps>>;
    /**
     * Basic button slot.
     */
    actionButton?: Slot<ButtonProps>;
    /**
     * Toggle button slot
     */
    toggleButton?: Slot<ToggleButtonProps>;
    /**
     * Menu button slot to stuff more things in when the other two aren't enough.
     */
    menuButton?: Slot<MenuButtonProps>;
    /**
     * Tooltip for the action button.
     */
    actionButtonTooltip?: Slot<TooltipProps>;
    /**
     * Tooltip for the toggle button.
     */
    toggleButtonTooltip?: Slot<TooltipProps>;
    /**
     * Tooltip for the menu button.
     */
    menuButtonTooltip?: Slot<TooltipProps>;
};

/**
 * State used in rendering SplitNavItem
 */
export declare type SplitNavItemState = ComponentState<SplitNavItemSlots> & {
    /**
     * The density of the NavItem
     *
     * @default 'medium'
     */
    density: NavDensity;
    /**
     * A boolean that represents if the main item in the SplitNavItem is a SubNav item.
     * If false, it's a NavItem.
     */
    isSubNav: boolean;
};

/**
 * Create the state required to render AppItem.
 *
 * The returned state can be modified with hooks such as useAppItemStyles_unstable,
 * before being passed to renderAppItem_unstable.
 *
 * @param props - props from this instance of AppItem
 * @param ref - reference to root HTMLDivElement of AppItem
 */
export declare const useAppItem_unstable: (props: AppItemProps, ref: React_2.Ref<HTMLButtonElement | HTMLAnchorElement>) => AppItemState;

/**
 * Create the state required to render AppItemStatic.
 *
 * The returned state can be modified with hooks such as useAppItemStaticStyles_unstable,
 * before being passed to renderAppItemStatic_unstable.
 *
 * @param props - props from this instance of AppItemStatic
 * @param ref - reference to root HTMLDivElement of AppItemStatic
 */
export declare const useAppItemStatic_unstable: (props: AppItemStaticProps, ref: React_2.Ref<HTMLDivElement>) => AppItemStaticState;

/**
 * Apply styling to the AppItemStatic slots based on the state
 */
export declare const useAppItemStaticStyles_unstable: (state: AppItemStaticState) => AppItemStaticState;

/**
 * Apply styling to the AppItem slots based on the state
 */
export declare const useAppItemStyles_unstable: (state: AppItemState) => AppItemState;

/**
 * Given user props, defines default props for the Button, calls useButtonState and useChecked, and returns
 * processed state.
 * @param props - User provided props to the Button component.
 * @param ref - User provided ref to be passed to the Button component.
 */
export declare const useHamburger_unstable: (props: HamburgerProps, ref: React_2.Ref<HTMLButtonElement | HTMLAnchorElement>) => HamburgerState;

/**
 * Apply styling to the Hamburger slots based on the state
 */
export declare const useHamburgerStyles_unstable: (state: HamburgerState) => HamburgerState;

/**
 * Create the state required to render Nav.
 *
 * The returned state can be modified with hooks such as useNavStyles,
 * before being passed to renderNav.
 *
 * @param props - props from this instance of Nav
 * @param ref - reference to root HTMLDivElement of Nav
 */
export declare const useNav_unstable: (props: NavProps, ref: React_2.Ref<HTMLDivElement>) => NavState;

/**
 * Create the state required to render NavCategory.
 *
 * The returned state can be modified with hooks such as useNavCategoryStyles_unstable,
 * before being passed to renderNavCategory_unstable.
 *
 * @param props - props from this instance of NavCategory
 * @param ref - reference to root HTMLDivElement of NavCategory
 */
export declare const useNavCategory_unstable: (props: NavCategoryProps, ref: React_2.Ref<HTMLDivElement>) => NavCategoryState;

export declare const useNavCategoryContext_unstable: () => NavCategoryContextValue;

export declare function useNavCategoryContextValues_unstable(state: NavCategoryState): NavCategoryContextValues;

/**
 * Create the state required to render NavCategoryItem.
 *
 * The returned state can be modified with hooks such as useNavCategoryItemStyles,
 * before being passed to renderNavCategoryItem.
 *
 * @param props - props from this instance of NavCategoryItem
 * @param ref - reference to root HTMLButtonElement of NavCategoryItem
 */
export declare const useNavCategoryItem_unstable: (props: NavCategoryItemProps, ref: React_2.Ref<HTMLButtonElement>) => NavCategoryItemState;

export declare const useNavCategoryItemContext_unstable: () => NavCategoryItemContextValue;

export declare function useNavCategoryItemContextValues_unstable(state: NavCategoryItemState): NavCategoryItemContextValues;

/**
 * Apply styling to the NavCategoryItem slots based on the state
 */
export declare const useNavCategoryItemStyles_unstable: (state: NavCategoryItemState) => NavCategoryItemState;

export declare const useNavContext_unstable: () => NavContextValue;

export declare function useNavContextValues_unstable(state: NavState): NavContextValues;

/**
 * Create the state required to render NavDivider.
 *
 * The returned state can be modified with hooks such as useNavDividerStyles_unstable,
 * before being passed to renderNavDivider_unstable.
 *
 * @param props - props from this instance of NavDivider
 * @param ref - reference to root HTMLDivElement of NavDivider
 */
export declare const useNavDivider_unstable: (props: NavDividerProps, ref: React_2.Ref<HTMLElement>) => NavDividerState;

/**
 * Apply styling to the NavDivider slots based on the state
 */
export declare const useNavDividerStyles_unstable: (state: NavDividerState) => NavDividerState;

/**
 * Create the state required to render NavDrawer.
 *
 * The returned state can be modified with hooks such as useNavDrawerStyles_unstable,
 * before being passed to renderNavDrawer_unstable.
 *
 * @param props - props from this instance of NavDrawer
 * @param ref - reference to root HTMLDivElement of NavDrawer
 */
export declare const useNavDrawer_unstable: (props: NavDrawerProps, ref: React_2.Ref<HTMLDivElement>) => NavDrawerState;

/**
 * Create the state required to render NavDrawerBody.
 *
 * The returned state can be modified with hooks such as useNavDrawerBodyStyles_unstable,
 * before being passed to renderNavDrawerBody_unstable.
 *
 * @param props - props from this instance of NavDrawerBody
 * @param ref - reference to root HTMLDivElement of NavDrawerBody
 */
export declare const useNavDrawerBody_unstable: (props: NavDrawerBodyProps, ref: React_2.Ref<HTMLDivElement>) => NavDrawerBodyState;

/**
 * Apply styling to the NavDrawerBody slots based on the state
 */
export declare const useNavDrawerBodyStyles_unstable: (state: NavDrawerBodyState) => NavDrawerBodyState;

/**
 * Create the state required to render NavDrawerFooter.
 *
 * The returned state can be modified with hooks such as useNavDrawerFooterStyles_unstable,
 * before being passed to renderNavDrawerFooter_unstable.
 *
 * @param props - props from this instance of NavDrawerFooter
 * @param ref - reference to root HTMLDivElement of NavDrawerFooter
 */
export declare const useNavDrawerFooter_unstable: (props: NavDrawerFooterProps, ref: React_2.Ref<HTMLElement>) => NavDrawerFooterState;

/**
 * Apply styling to the NavDrawerFooter slots based on the state
 */
export declare const useNavDrawerFooterStyles_unstable: (state: NavDrawerFooterState) => NavDrawerFooterState;

/**
 * Create the state required to render NavDrawerHeader.
 *
 * The returned state can be modified with hooks such as useNavDrawerHeaderStyles_unstable,
 * before being passed to renderNavDrawerHeader_unstable.
 *
 * @param props - props from this instance of NavDrawerHeader
 * @param ref - reference to root HTMLDivElement of NavDrawerHeader
 */
export declare const useNavDrawerHeader_unstable: (props: NavDrawerHeaderProps, ref: React_2.Ref<HTMLElement>) => NavDrawerHeaderState;

/**
 * Apply styling to the NavDrawerHeader slots based on the state
 */
export declare const useNavDrawerHeaderStyles_unstable: (state: NavDrawerHeaderState) => NavDrawerHeaderState;

/**
 * Apply styling to the NavDrawer slots based on the state
 */
export declare const useNavDrawerStyles_unstable: (state: NavDrawerState) => NavDrawerState;

/**
 * Create the state required to render NavItem.
 *
 * The returned state can be modified with hooks such as useNavItemStyles_unstable,
 * before being passed to renderNavItem_unstable.
 *
 * @param props - props from this instance of NavItem
 * @param ref - reference to root HTMLAnchorElement of NavItem
 */
export declare const useNavItem_unstable: (props: NavItemProps, ref: React_2.Ref<HTMLButtonElement | HTMLAnchorElement>) => NavItemState;

/**
 * Apply styling to the NavItem slots based on the state
 */
export declare const useNavItemStyles_unstable: (state: NavItemState) => NavItemState;

/**
 * Create the state required to render NavSectionHeader.
 *
 * The returned state can be modified with hooks such as useNavSectionHeaderStyles_unstable,
 * before being passed to renderNavSectionHeader_unstable.
 *
 * @param props - props from this instance of NavSectionHeader
 * @param ref - reference to root HTMLDivElement of NavSectionHeader
 */
export declare const useNavSectionHeader_unstable: (props: NavSectionHeaderProps, ref: React_2.Ref<HTMLDivElement>) => NavSectionHeaderState;

/**
 * Apply styling to the NavSectionHeader slots based on the state
 */
export declare const useNavSectionHeaderStyles_unstable: (state: NavSectionHeaderState) => NavSectionHeaderState;

/**
 * Apply styling to the Nav slots based on the state
 */
export declare const useNavStyles_unstable: (state: NavState) => NavState;

/**
 * Create the state required to render NavSubItem.
 *
 * The returned state can be modified with hooks such as useNavSubItemStyles_unstable,
 * before being passed to renderNavSubItem_unstable.
 *
 * @param props - props from this instance of NavSubItem
 * @param ref - reference to root HTMLButtonElement of NavSubItem
 */
export declare const useNavSubItem_unstable: (props: NavSubItemProps, ref: React_2.Ref<HTMLButtonElement | HTMLAnchorElement>) => NavSubItemState;

/**
 * Create the state required to render NavSubItemGroup.
 *
 * The returned state can be modified with hooks such as useNavSubItemGroupStyles_unstable,
 * before being passed to renderNavSubItemGroup_unstable.
 *
 * @param props - props from this instance of NavSubItemGroup
 * @param ref - reference to root HTMLDivElement of NavSubItemGroup
 */
export declare const useNavSubItemGroup_unstable: (props: NavSubItemGroupProps, ref: React_2.Ref<HTMLDivElement>) => NavSubItemGroupState;

/**
 * Apply styling to the NavSubItemGroup slots based on the state
 */
export declare const useNavSubItemGroupStyles_unstable: (state: NavSubItemGroupState) => NavSubItemGroupState;

/**
 * Apply styling to the NavSubItem slots based on the state
 */
export declare const useNavSubItemStyles_unstable: (state: NavSubItemState) => NavSubItemState;

/**
 * Create the state required to render SplitNavItem.
 *
 * The returned state can be modified with hooks such as useSplitNavItemStyles_unstable,
 * before being passed to renderSplitNavItem_unstable.
 *
 * @param props - props from this instance of SplitNavItem
 * @param ref - reference to root HTMLDivElement of SplitNavItem
 */
export declare const useSplitNavItem_unstable: (props: SplitNavItemProps, ref: React_2.Ref<HTMLDivElement>) => SplitNavItemState;

/**
 * Apply styling to the SplitNavItem slots based on the state
 */
export declare const useSplitNavItemStyles_unstable: (state: SplitNavItemState) => SplitNavItemState;

export { }
