import * as React from 'react';
import { SLOT_ELEMENT_TYPE_SYMBOL, SLOT_RENDER_FUNCTION_SYMBOL } from '@fluentui/react-utilities';
export function presenceMotionSlot(motion, options) {
    // eslint-disable-next-line @typescript-eslint/no-deprecated
    const { as, children, ...rest } = motion !== null && motion !== void 0 ? motion : {};
    if (process.env.NODE_ENV !== 'production') {
        if (typeof as !== 'undefined') {
            throw new Error(`@fluentui/react-motion: "as" property is not supported on motion slots.`);
        }
    }
    if (motion === null) {
        // Heads up!
        // Render function is used there to avoid rendering a motion component and handle unmounting logic
        const isUnmounted = !options.defaultProps.visible && options.defaultProps.unmountOnExit;
        const renderFn = (_, props)=>isUnmounted ? null : /*#__PURE__*/ React.createElement(React.Fragment, null, props.children);
        /**
     * Casting is required here as SlotComponentType is a function, not an object.
     * Although SlotComponentType has a function signature, it is still just an object.
     * This is required to make a slot callable (JSX compatible), this is the exact same approach
     * that is used on `@types/react` components
     */ return {
            [SLOT_RENDER_FUNCTION_SYMBOL]: renderFn,
            [SLOT_ELEMENT_TYPE_SYMBOL]: options.elementType
        };
    }
    /**
   * Casting is required here as SlotComponentType is a function, not an object.
   * Although SlotComponentType has a function signature, it is still just an object.
   * This is required to make a slot callable (JSX compatible), this is the exact same approach
   * that is used on `@types/react` components
   */ const propsWithMetadata = {
        ...options.defaultProps,
        ...rest,
        [SLOT_ELEMENT_TYPE_SYMBOL]: options.elementType
    };
    if (typeof children === 'function') {
        propsWithMetadata[SLOT_RENDER_FUNCTION_SYMBOL] = children;
    }
    return propsWithMetadata;
}
