'use client';
import { _ as _define_property } from "@swc/helpers/_/_define_property";
import * as React from 'react';
import { getNextChildMapping } from '../utils/groups/getNextChildMapping';
import { getChildMapping } from '../utils/groups/getChildMapping';
import { PresenceGroupItemProvider } from './PresenceGroupItemProvider';
/* eslint-disable @typescript-eslint/explicit-member-accessibility */ /* eslint-disable @typescript-eslint/naming-convention */ /* eslint-disable @typescript-eslint/member-ordering */ export class PresenceGroup extends React.Component {
    static getDerivedStateFromProps(nextProps, { childMapping: prevChildMapping, firstRender }) {
        const nextChildMapping = getChildMapping(nextProps.children);
        return {
            childMapping: firstRender ? nextChildMapping : getNextChildMapping(prevChildMapping, nextChildMapping),
            firstRender: false
        };
    }
    componentDidMount() {
        this.mounted = true;
    }
    componentWillUnmount() {
        this.mounted = false;
    }
    render() {
        return /*#__PURE__*/ React.createElement(React.Fragment, null, Object.entries(this.state.childMapping).map(([childKey, childProps])=>/*#__PURE__*/ React.createElement(PresenceGroupItemProvider, {
                ...childProps,
                childKey: childKey,
                key: childKey,
                onExit: this.handleExit
            }, childProps.element)));
    }
    constructor(props, context){
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore - React.Component constructor has only one argument in React 19
        super(props, context), _define_property(this, "mounted", false), _define_property(this, "handleExit", (childKey)=>{
            const currentChildMapping = getChildMapping(this.props.children);
            if (childKey in currentChildMapping) {
                return;
            }
            if (this.mounted) {
                this.setState((state)=>{
                    const childMapping = {
                        ...state.childMapping
                    };
                    delete childMapping[childKey];
                    return {
                        childMapping
                    };
                });
            }
        }); // eslint-disable-line @typescript-eslint/no-deprecated
        this.state = {
            childMapping: {},
            firstRender: true
        };
    }
}
