'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useChildElement", {
    enumerable: true,
    get: function() {
        return useChildElement;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const CHILD_ERROR_MESSAGE = [
    '@fluentui/react-motion: Invalid child element.',
    '\n',
    'Motion factories require a single child element to be passed. ',
    'That element element should support ref forwarding i.e. it should be either an intrinsic element (e.g. div) or a component that uses React.forwardRef().'
].join('');
function useChildElement(children, mounted = true) {
    const childRef = _react.useRef(null);
    _react.useEffect(()=>{
        if (process.env.NODE_ENV !== 'production') {
            if (mounted && !childRef.current) {
                // eslint-disable-next-line no-console
                console.error(CHILD_ERROR_MESSAGE);
            }
        }
    }, [
        mounted
    ]);
    try {
        const child = _react.Children.only(children);
        if (_react.isValidElement(child)) {
            return [
                _react.cloneElement(child, {
                    ref: (0, _reactutilities.useMergedRefs)(childRef, (0, _reactutilities.getReactElementRef)(child))
                }),
                childRef
            ];
        }
    } catch  {
    /* empty */ }
    throw new Error(CHILD_ERROR_MESSAGE);
}
