'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useMountedState", {
    enumerable: true,
    get: function() {
        return useMountedState;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
function useMountedState(visible = false, unmountOnExit = false) {
    const mountedRef = _react.useRef(unmountOnExit ? visible : true);
    const forceUpdate = (0, _reactutilities.useForceUpdate)();
    const setMounted = _react.useCallback((newValue)=>{
        if (mountedRef.current !== newValue) {
            mountedRef.current = newValue;
            forceUpdate();
        }
    }, [
        forceUpdate
    ]);
    _react.useEffect(()=>{
        if (visible) {
            mountedRef.current = visible;
        }
    });
    return [
        visible || mountedRef.current,
        setMounted
    ];
}
