'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useMotionImperativeRef", {
    enumerable: true,
    get: function() {
        return useMotionImperativeRef;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
function useMotionImperativeRef(imperativeRef) {
    const animationRef = _react.useRef(undefined);
    _react.useImperativeHandle(imperativeRef, ()=>({
            setPlayState: (state)=>{
                if (state === 'running') {
                    var _animationRef_current;
                    (_animationRef_current = animationRef.current) === null || _animationRef_current === void 0 ? void 0 : _animationRef_current.play();
                }
                if (state === 'paused') {
                    var _animationRef_current1;
                    (_animationRef_current1 = animationRef.current) === null || _animationRef_current1 === void 0 ? void 0 : _animationRef_current1.pause();
                }
            },
            setPlaybackRate: (rate)=>{
                if (animationRef.current) {
                    animationRef.current.playbackRate = rate;
                }
            }
        }));
    return animationRef;
}
