'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useIsReducedMotion", {
    enumerable: true,
    get: function() {
        return useIsReducedMotion;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const REDUCED_MEDIA_QUERY = 'screen and (prefers-reduced-motion: reduce)';
function useIsReducedMotion() {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    var _targetDocument_defaultView;
    const targetWindow = (_targetDocument_defaultView = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView) !== null && _targetDocument_defaultView !== void 0 ? _targetDocument_defaultView : null;
    const queryValue = _react.useRef(false);
    const isEnabled = _react.useCallback(()=>queryValue.current, []);
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        if (targetWindow === null || typeof targetWindow.matchMedia !== 'function') {
            return;
        }
        const queryMatch = targetWindow.matchMedia(REDUCED_MEDIA_QUERY);
        if (queryMatch.matches) {
            queryValue.current = true;
        }
        const matchListener = (e)=>{
            queryValue.current = e.matches;
        };
        queryMatch.addEventListener('change', matchListener);
        return ()=>{
            queryMatch.removeEventListener('change', matchListener);
        };
    }, [
        targetWindow
    ]);
    return isEnabled;
}
