"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createPresenceComponentVariant: function() {
        return createPresenceComponentVariant;
    },
    createPresenceFnVariant: function() {
        return createPresenceFnVariant;
    }
});
const _createPresenceComponent = require("./createPresenceComponent");
function createPresenceFnVariant(presenceFn, variantParams) {
    const variantFn = (runtimeParams)=>presenceFn({
            ...variantParams,
            ...runtimeParams
        });
    return variantFn;
}
function createPresenceComponentVariant(component, variantParams) {
    const originalFn = component[_createPresenceComponent.PRESENCE_MOTION_DEFINITION];
    // The variant params become new defaults, but they can still be overridden by runtime params.
    const variantFn = createPresenceFnVariant(originalFn, variantParams);
    return (0, _createPresenceComponent.createPresenceComponent)(variantFn);
}
