'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    MOTION_DEFINITION: function() {
        return MOTION_DEFINITION;
    },
    createMotionComponent: function() {
        return createMotionComponent;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _useAnimateAtoms = require("../hooks/useAnimateAtoms");
const _useMotionImperativeRef = require("../hooks/useMotionImperativeRef");
const _useIsReducedMotion = require("../hooks/useIsReducedMotion");
const _useChildElement = require("../utils/useChildElement");
const _MotionBehaviourContext = require("../contexts/MotionBehaviourContext");
const MOTION_DEFINITION = Symbol('MOTION_DEFINITION');
function createMotionComponent(value) {
    const Atom = (props)=>{
        'use no memo';
        const { children, imperativeRef, onMotionFinish: onMotionFinishProp, onMotionStart: onMotionStartProp, onMotionCancel: onMotionCancelProp, ..._rest } = props;
        const params = _rest;
        const [child, childRef] = (0, _useChildElement.useChildElement)(children);
        const handleRef = (0, _useMotionImperativeRef.useMotionImperativeRef)(imperativeRef);
        const skipMotions = (0, _MotionBehaviourContext.useMotionBehaviourContext)() === 'skip';
        const optionsRef = _react.useRef({
            skipMotions,
            params
        });
        const animateAtoms = (0, _useAnimateAtoms.useAnimateAtoms)();
        const isReducedMotion = (0, _useIsReducedMotion.useIsReducedMotion)();
        const onMotionStart = (0, _reactutilities.useEventCallback)(()=>{
            onMotionStartProp === null || onMotionStartProp === void 0 ? void 0 : onMotionStartProp(null);
        });
        const onMotionFinish = (0, _reactutilities.useEventCallback)(()=>{
            onMotionFinishProp === null || onMotionFinishProp === void 0 ? void 0 : onMotionFinishProp(null);
        });
        const onMotionCancel = (0, _reactutilities.useEventCallback)(()=>{
            onMotionCancelProp === null || onMotionCancelProp === void 0 ? void 0 : onMotionCancelProp(null);
        });
        (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
            // Heads up!
            // We store the params in a ref to avoid re-rendering the component when the params change.
            optionsRef.current = {
                skipMotions,
                params
            };
        });
        (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
            const element = childRef.current;
            if (element) {
                const atoms = typeof value === 'function' ? value({
                    element,
                    ...optionsRef.current.params
                }) : value;
                onMotionStart();
                const handle = animateAtoms(element, atoms, {
                    isReducedMotion: isReducedMotion()
                });
                handleRef.current = handle;
                handle.setMotionEndCallbacks(onMotionFinish, onMotionCancel);
                if (optionsRef.current.skipMotions) {
                    handle.finish();
                }
                return ()=>{
                    handle.cancel();
                };
            }
        }, [
            animateAtoms,
            childRef,
            handleRef,
            isReducedMotion,
            onMotionFinish,
            onMotionStart,
            onMotionCancel
        ]);
        return child;
    };
    return Object.assign(Atom, {
        // Heads up!
        // Always normalize it to a function to simplify types
        [MOTION_DEFINITION]: typeof value === 'function' ? value : ()=>value
    });
}
