'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PresenceGroup", {
    enumerable: true,
    get: function() {
        return PresenceGroup;
    }
});
const _define_property = require("@swc/helpers/_/_define_property");
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _getNextChildMapping = require("../utils/groups/getNextChildMapping");
const _getChildMapping = require("../utils/groups/getChildMapping");
const _PresenceGroupItemProvider = require("./PresenceGroupItemProvider");
class PresenceGroup extends _react.Component {
    static getDerivedStateFromProps(nextProps, { childMapping: prevChildMapping, firstRender }) {
        const nextChildMapping = (0, _getChildMapping.getChildMapping)(nextProps.children);
        return {
            childMapping: firstRender ? nextChildMapping : (0, _getNextChildMapping.getNextChildMapping)(prevChildMapping, nextChildMapping),
            firstRender: false
        };
    }
    componentDidMount() {
        this.mounted = true;
    }
    componentWillUnmount() {
        this.mounted = false;
    }
    render() {
        return /*#__PURE__*/ _react.createElement(_react.Fragment, null, Object.entries(this.state.childMapping).map(([childKey, childProps])=>/*#__PURE__*/ _react.createElement(_PresenceGroupItemProvider.PresenceGroupItemProvider, {
                ...childProps,
                childKey: childKey,
                key: childKey,
                onExit: this.handleExit
            }, childProps.element)));
    }
    constructor(props, context){
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore - React.Component constructor has only one argument in React 19
        super(props, context), _define_property._(this, "mounted", false), _define_property._(this, "handleExit", (childKey)=>{
            const currentChildMapping = (0, _getChildMapping.getChildMapping)(this.props.children);
            if (childKey in currentChildMapping) {
                return;
            }
            if (this.mounted) {
                this.setState((state)=>{
                    const childMapping = {
                        ...state.childMapping
                    };
                    delete childMapping[childKey];
                    return {
                        childMapping
                    };
                });
            }
        }); // eslint-disable-line @typescript-eslint/no-deprecated
        this.state = {
            childMapping: {},
            firstRender: true
        };
    }
}
