import { motionTokens, createPresenceComponent, createPresenceComponentVariant } from '@fluentui/react-motion';
import { fadeAtom } from '../../atoms/fade-atom';
import { scaleAtom } from '../../atoms/scale-atom';
/**
 * Define a presence motion for scale in/out
 *
 * @param duration - Time (ms) for the enter transition (scale-in). Defaults to the `durationGentle` value (250 ms).
 * @param easing - Easing curve for the enter transition (scale-in). Defaults to the `curveDecelerateMax` value.
 * @param delay - Time (ms) to delay the enter transition. Defaults to 0.
 * @param exitDuration - Time (ms) for the exit transition (scale-out). Defaults to the `durationNormal` value (200 ms).
 * @param exitEasing - Easing curve for the exit transition (scale-out). Defaults to the `curveAccelerateMax` value.
 * @param exitDelay - Time (ms) to delay the exit transition. Defaults to the `delay` param for symmetry.
 * @param fromScale - The scale value to animate from. Defaults to `0.9`.
 * @param toScale - The scale value to animate to. Defaults to `1`.
 * @param animateOpacity - Whether to animate the opacity. Defaults to `true`.
 */ const scalePresenceFn = ({ duration = motionTokens.durationGentle, easing = motionTokens.curveDecelerateMax, delay = 0, exitDuration = motionTokens.durationNormal, exitEasing = motionTokens.curveAccelerateMax, exitDelay = delay, fromScale = 0.9, toScale = 1, animateOpacity = true })=>{
    const enterAtoms = [
        scaleAtom({
            direction: 'enter',
            duration,
            easing,
            delay,
            fromScale,
            toScale
        })
    ];
    const exitAtoms = [
        scaleAtom({
            direction: 'exit',
            duration: exitDuration,
            easing: exitEasing,
            delay: exitDelay,
            fromScale,
            toScale
        })
    ];
    // Only add fade atoms if animateOpacity is true.
    if (animateOpacity) {
        enterAtoms.push(fadeAtom({
            direction: 'enter',
            duration,
            easing,
            delay
        }));
        exitAtoms.push(fadeAtom({
            direction: 'exit',
            duration: exitDuration,
            easing: exitEasing,
            delay: exitDelay
        }));
    }
    return {
        enter: enterAtoms,
        exit: exitAtoms
    };
};
/** A React component that applies scale in/out transitions to its children. */ export const Scale = createPresenceComponent(scalePresenceFn);
export const ScaleSnappy = createPresenceComponentVariant(Scale, {
    duration: motionTokens.durationNormal,
    exitDuration: motionTokens.durationFast
});
export const ScaleRelaxed = createPresenceComponentVariant(Scale, {
    duration: motionTokens.durationSlow,
    exitDuration: motionTokens.durationGentle
});
