import { motionTokens } from '@fluentui/react-motion';
/**
 * Generates a motion atom object for a blur-in or blur-out.
 * @param direction - The functional direction of the motion: 'enter' or 'exit'.
 * @param duration - The duration of the motion in milliseconds.
 * @param easing - The easing curve for the motion. Defaults to `motionTokens.curveLinear`.
 * @param fromRadius - The blur radius value with units (e.g., '20px', '1rem'). Defaults to '10px'.
 * @param toRadius - The ending blur radius value with units (e.g., '0px', '5px'). Defaults to '0px'.
 * @param delay - Time (ms) to delay the animation. Defaults to 0.
 * @returns A motion atom object with filter blur keyframes and the supplied duration and easing.
 */ export const blurAtom = ({ direction, duration, easing = motionTokens.curveLinear, delay = 0, fromRadius = '10px', toRadius = '0px' })=>{
    const keyframes = [
        {
            filter: `blur(${fromRadius})`
        },
        {
            filter: `blur(${toRadius})`
        }
    ];
    if (direction === 'exit') {
        keyframes.reverse();
    }
    return {
        keyframes,
        duration,
        easing,
        delay
    };
};
