"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    Scale: function() {
        return Scale;
    },
    ScaleRelaxed: function() {
        return ScaleRelaxed;
    },
    ScaleSnappy: function() {
        return ScaleSnappy;
    }
});
const _reactmotion = require("@fluentui/react-motion");
const _fadeatom = require("../../atoms/fade-atom");
const _scaleatom = require("../../atoms/scale-atom");
/**
 * Define a presence motion for scale in/out
 *
 * @param duration - Time (ms) for the enter transition (scale-in). Defaults to the `durationGentle` value (250 ms).
 * @param easing - Easing curve for the enter transition (scale-in). Defaults to the `curveDecelerateMax` value.
 * @param delay - Time (ms) to delay the enter transition. Defaults to 0.
 * @param exitDuration - Time (ms) for the exit transition (scale-out). Defaults to the `durationNormal` value (200 ms).
 * @param exitEasing - Easing curve for the exit transition (scale-out). Defaults to the `curveAccelerateMax` value.
 * @param exitDelay - Time (ms) to delay the exit transition. Defaults to the `delay` param for symmetry.
 * @param fromScale - The scale value to animate from. Defaults to `0.9`.
 * @param toScale - The scale value to animate to. Defaults to `1`.
 * @param animateOpacity - Whether to animate the opacity. Defaults to `true`.
 */ const scalePresenceFn = ({ duration = _reactmotion.motionTokens.durationGentle, easing = _reactmotion.motionTokens.curveDecelerateMax, delay = 0, exitDuration = _reactmotion.motionTokens.durationNormal, exitEasing = _reactmotion.motionTokens.curveAccelerateMax, exitDelay = delay, fromScale = 0.9, toScale = 1, animateOpacity = true })=>{
    const enterAtoms = [
        (0, _scaleatom.scaleAtom)({
            direction: 'enter',
            duration,
            easing,
            delay,
            fromScale,
            toScale
        })
    ];
    const exitAtoms = [
        (0, _scaleatom.scaleAtom)({
            direction: 'exit',
            duration: exitDuration,
            easing: exitEasing,
            delay: exitDelay,
            fromScale,
            toScale
        })
    ];
    // Only add fade atoms if animateOpacity is true.
    if (animateOpacity) {
        enterAtoms.push((0, _fadeatom.fadeAtom)({
            direction: 'enter',
            duration,
            easing,
            delay
        }));
        exitAtoms.push((0, _fadeatom.fadeAtom)({
            direction: 'exit',
            duration: exitDuration,
            easing: exitEasing,
            delay: exitDelay
        }));
    }
    return {
        enter: enterAtoms,
        exit: exitAtoms
    };
};
const Scale = (0, _reactmotion.createPresenceComponent)(scalePresenceFn);
const ScaleSnappy = (0, _reactmotion.createPresenceComponentVariant)(Scale, {
    duration: _reactmotion.motionTokens.durationNormal,
    exitDuration: _reactmotion.motionTokens.durationFast
});
const ScaleRelaxed = (0, _reactmotion.createPresenceComponentVariant)(Scale, {
    duration: _reactmotion.motionTokens.durationSlow,
    exitDuration: _reactmotion.motionTokens.durationGentle
});
