"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    Fade: function() {
        return Fade;
    },
    FadeRelaxed: function() {
        return FadeRelaxed;
    },
    FadeSnappy: function() {
        return FadeSnappy;
    },
    fadePresenceFn: function() {
        return fadePresenceFn;
    }
});
const _reactmotion = require("@fluentui/react-motion");
const _fadeatom = require("../../atoms/fade-atom");
const fadePresenceFn = ({ duration = _reactmotion.motionTokens.durationNormal, easing = _reactmotion.motionTokens.curveEasyEase, delay = 0, exitDuration = duration, exitEasing = easing, exitDelay = delay, fromOpacity = 0, toOpacity = 1 })=>{
    return {
        enter: (0, _fadeatom.fadeAtom)({
            direction: 'enter',
            duration,
            easing,
            delay,
            fromOpacity,
            toOpacity
        }),
        exit: (0, _fadeatom.fadeAtom)({
            direction: 'exit',
            duration: exitDuration,
            easing: exitEasing,
            delay: exitDelay,
            fromOpacity,
            toOpacity
        })
    };
};
const Fade = (0, _reactmotion.createPresenceComponent)(fadePresenceFn);
const FadeSnappy = (0, _reactmotion.createPresenceComponentVariant)(Fade, {
    duration: _reactmotion.motionTokens.durationFast
});
const FadeRelaxed = (0, _reactmotion.createPresenceComponentVariant)(Fade, {
    duration: _reactmotion.motionTokens.durationGentle
});
