"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "blurAtom", {
    enumerable: true,
    get: function() {
        return blurAtom;
    }
});
const _reactmotion = require("@fluentui/react-motion");
const blurAtom = ({ direction, duration, easing = _reactmotion.motionTokens.curveLinear, delay = 0, fromRadius = '10px', toRadius = '0px' })=>{
    const keyframes = [
        {
            filter: `blur(${fromRadius})`
        },
        {
            filter: `blur(${toRadius})`
        }
    ];
    if (direction === 'exit') {
        keyframes.reverse();
    }
    return {
        keyframes,
        duration,
        easing,
        delay
    };
};
