'use client';
import * as React from 'react';
const MotionRefForwarderContext = /*#__PURE__*/ React.createContext(undefined);
/**
 * @internal
 */ export function useMotionForwardedRef() {
    return React.useContext(MotionRefForwarderContext);
}
/**
 * A component that forwards a ref to its children via a React context.
 *
 * @internal
 */ export const MotionRefForwarder = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    return /*#__PURE__*/ React.createElement(MotionRefForwarderContext.Provider, {
        value: ref
    }, props.children);
});
