'use client';
import { makeResetStyles, mergeClasses } from '@griffel/react';
import { tokens, typographyStyles } from '@fluentui/react-theme';
export const messageBarBodyClassNames = {
    root: 'fui-MessageBarBody'
};
const useRootBaseStyles = makeResetStyles({
    ...typographyStyles.body1,
    gridArea: 'body',
    paddingRight: tokens.spacingHorizontalM
});
/**
 * Apply styling to the MessageBarBody slots based on the state
 */ export const useMessageBarBodyStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseStyles = useRootBaseStyles();
    state.root.className = mergeClasses(messageBarBodyClassNames.root, rootBaseStyles, state.root.className);
    return state;
};
