'use client';
import * as React from 'react';
import { getIntrinsicElementProps, slot, useId, useMergedRefs } from '@fluentui/react-utilities';
import { useAnnounce } from '@fluentui/react-shared-contexts';
import { getIntentIcon } from './getIntentIcon';
import { useMessageBarReflow } from './useMessageBarReflow';
import { useMessageBarTransitionContext } from '../../contexts/messageBarTransitionContext';
import { useMotionForwardedRef } from '../MotionRefForwarder';
/**
 * Create the state required to render MessageBar.
 *
 * The returned state can be modified with hooks such as useMessageBarStyles_unstable,
 * before being passed to renderMessageBar_unstable.
 *
 * @param props - props from this instance of MessageBar
 * @param ref - reference to root HTMLElement of MessageBar
 */ export const useMessageBar_unstable = (props, ref)=>{
    const { layout = 'auto', intent = 'info', politeness, shape = 'rounded' } = props;
    const computedPoliteness = (politeness !== null && politeness !== void 0 ? politeness : intent === 'info') ? 'polite' : 'assertive';
    const autoReflow = layout === 'auto';
    const { ref: reflowRef, reflowing } = useMessageBarReflow(autoReflow);
    const computedLayout = autoReflow ? reflowing ? 'multiline' : 'singleline' : layout;
    // eslint-disable-next-line @typescript-eslint/no-deprecated
    const { className: transitionClassName, nodeRef } = useMessageBarTransitionContext();
    const motionRef = useMotionForwardedRef();
    const actionsRef = React.useRef(null);
    const bodyRef = React.useRef(null);
    const { announce } = useAnnounce();
    const titleId = useId();
    React.useEffect(()=>{
        var _bodyRef_current, _actionsRef_current;
        const bodyMessage = (_bodyRef_current = bodyRef.current) === null || _bodyRef_current === void 0 ? void 0 : _bodyRef_current.textContent;
        const actionsMessage = (_actionsRef_current = actionsRef.current) === null || _actionsRef_current === void 0 ? void 0 : _actionsRef_current.textContent;
        const message = [
            bodyMessage,
            actionsMessage
        ].filter(Boolean).join(',');
        announce(message, {
            polite: computedPoliteness === 'polite',
            alert: computedPoliteness === 'assertive'
        });
    }, [
        bodyRef,
        actionsRef,
        announce,
        computedPoliteness
    ]);
    return {
        components: {
            root: 'div',
            icon: 'div',
            bottomReflowSpacer: 'div'
        },
        root: slot.always(getIntrinsicElementProps('div', {
            ref: useMergedRefs(ref, reflowRef, nodeRef, motionRef),
            role: 'group',
            'aria-labelledby': titleId,
            ...props
        }), {
            elementType: 'div'
        }),
        icon: slot.optional(props.icon, {
            renderByDefault: true,
            elementType: 'div',
            defaultProps: {
                children: getIntentIcon(intent)
            }
        }),
        bottomReflowSpacer: slot.optional(props.bottomReflowSpacer, {
            renderByDefault: computedLayout === 'multiline',
            elementType: 'div'
        }),
        layout: computedLayout,
        intent,
        transitionClassName,
        actionsRef,
        bodyRef,
        titleId,
        shape
    };
};
