'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    messageBarTitleClassNames: function() {
        return messageBarTitleClassNames;
    },
    useMessageBarTitleStyles_unstable: function() {
        return useMessageBarTitleStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const messageBarTitleClassNames = {
    root: 'fui-MessageBarTitle'
};
/**
 * Styles for the root slot
 */ const useRootBaseStyles = (0, _react.makeResetStyles)({
    ..._reacttheme.typographyStyles.body1Strong,
    '::after': {
        content: '" "'
    }
});
const useMessageBarTitleStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseStyles = useRootBaseStyles();
    state.root.className = (0, _react.mergeClasses)(messageBarTitleClassNames.root, rootBaseStyles, state.root.className);
    return state;
};
