"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    MessageBarMotion: function() {
        return MessageBarMotion;
    },
    fadeAtom: function() {
        return fadeAtom;
    },
    slideAtom: function() {
        return slideAtom;
    }
});
const _reactmotion = require("@fluentui/react-motion");
const fadeAtom = ({ direction, duration, easing = _reactmotion.motionTokens.curveLinear, delay = 0, fromOpacity = 0 })=>{
    const keyframes = [
        {
            opacity: fromOpacity
        },
        {
            opacity: 1
        }
    ];
    if (direction === 'exit') {
        keyframes.reverse();
    }
    return {
        keyframes,
        duration,
        easing,
        delay,
        // Applying opacity backwards and forwards in time is important
        // to avoid a bug where a delayed animation is not hidden when it should be.
        fill: 'both'
    };
};
const slideAtom = ({ direction, duration, easing = _reactmotion.motionTokens.curveLinear, delay = 0, fromX = '0px', fromY = '20px' })=>{
    const keyframes = [
        {
            translate: `${fromX} ${fromY}`
        },
        {
            translate: '0px 0px'
        }
    ];
    if (direction === 'exit') {
        keyframes.reverse();
    }
    return {
        keyframes,
        duration,
        easing,
        delay
    };
};
const MessageBarMotion = (0, _reactmotion.createPresenceComponent)(({ animate })=>{
    const duration = _reactmotion.motionTokens.durationGentle;
    return {
        enter: animate === 'both' ? [
            fadeAtom({
                direction: 'enter',
                duration
            }),
            slideAtom({
                direction: 'enter',
                fromY: '-100%',
                duration
            })
        ] : [],
        // Always exit with a fade
        exit: fadeAtom({
            direction: 'exit',
            duration
        })
    };
});
